<x-modal maxWidth="max-w-lg" @open-pin-modal.window="openModal()" @close-pin-modal.window="close()"
    x-on:pin-success.window="close()">

    {{-- Header --}}
    <div class="flex items-start gap-4 mb-6">
        <div
            class="w-11 h-11 aspect-square rounded-xl flex items-center justify-center
bg-white/20 dark:bg-white/10
backdrop-blur-md
border border-white/30 dark:border-white/10
shadow-[0_0_20px_rgba(56,189,248,0.25)]">

            <x-flux::icon.check-circle variant="solid" class="w-5 h-5 text-sky-700 dark:text-sky-400" />
        </div>

        <div>
            <h2 class="text-lg font-semibold text-gray-900 dark:text-white">
                Create Transaction PIN
            </h2>
            <p class="mt-1 text-sm text-gray-600 dark:text-gray-300 leading-relaxed">
                Set a 4-digit PIN to secure your transactions. You’ll be asked for this PIN whenever you make a
                withdrawal or transfer.
            </p>
        </div>
    </div>

    <div class="my-3">
        <!-- PIN input -->
        <x-input type="password" maxlength="4" label="Transaction Pin" inputmode="numeric" wire:model.defer="pin"
            placeholder="****" viewable />
    </div>

    {{-- Actions --}}
    <div class="flex justify-end gap-3">
        <x-button type="button" variant="ghost" @click="$dispatch('close-pin-modal'); $wire.cancel-pin-modal()">
            Cancel
        </x-button>

        <x-button type="button" wire:click="createPin" class="bg-sky-600 hover:bg-sky-700 text-white">
            Create Pin
        </x-button>
    </div>

</x-modal>
