@props([
    'title' => 'Users Management',
    'subtitle' => 'Overview of all registered users, their profiles, KYC status, and activity.',
    'backUrl' => '',
    'rightText' => 'dashboard',
])
<div class="flex flex-col sm:flex-row sm:items-center sm:justify-between mb-8 gap-4">

    {{-- Left side: Title + Subtitle --}}
    <div class="flex flex-col">
        <h1 class="text-base md:text-2xl font-bold text-gray-900 dark:text-gray-100 leading-tight truncate">
            {{ $title }}
        </h1>
        @if ($subtitle)
            <p class="text-gray-500 dark:text-gray-400 text-xs sm:text-sm truncate">
                {{ $subtitle }}
            </p>
        @endif
    </div>

    {{-- Right side: Back Button --}}
    @if ($backUrl)
        <a href="{{ $backUrl }}"
            class=" md:flex hidden items-center capitalize px-4 py-2 text-sm font-medium rounded-lg bg-gray-100 dark:bg-gray-700 text-gray-800 dark:text-gray-100 hover:bg-gray-200 dark:hover:bg-gray-600 transition shadow-sm">
            <x-flux::icon.arrow-left class="w-5 h-5 mr-2" />
            {{ $rightText }}
        </a>
    @endif

</div>
