@props(['maxWidth' => 'max-w-md'])

<div x-data="toggle(false)" x-show="open" x-cloak {{ $attributes }} @keydown.escape.window="close()"
    class="fixed inset-0 z-50 flex items-start justify-center px-4 py-6 sm:px-6 lg:px-8">

    <!-- Backdrop -->
    <div x-show="open" x-transition.opacity.duration.200ms class="absolute inset-0 bg-black/50 backdrop-blur-sm"
        @click="close()">
    </div>

    <!-- Modal -->
    <div x-show="open" x-transition.opacity @click.away="close()"
        class="
            relative
            w-full
            {{ $maxWidth }}
            bg-white dark:bg-gray-800
            rounded-xl
            shadow-xl
            p-6
            overscroll-contain scrollbar-thin
            my-4
            max-h-[calc(100vh-5rem)]
            overflow-y-auto
        ">
        {{ $slot }}
    </div>

</div>
