@props([
    'instructions' => [],
    'title' => 'Instructions',
    'icon' => 'send'
])

@if (!empty($instructions))
    <div
        class="space-y-6 p-6 rounded-xl
               bg-linear-to-br from-sky-50/50 to-white/50
               dark:from-gray-900/50 dark:to-gray-800/50">

        {{-- Header --}}
        <div class="flex items-center gap-3">
            <div
                class="flex items-center justify-center w-10 h-10 rounded-lg
                        bg-sky-200 dark:bg-sky-700">
                <x-flux::icon :name="$icon" class="w-5 h-5 text-sky-700 dark:text-white" />
            </div>

            <h3 class="text-lg font-bold text-gray-900 dark:text-gray-100">
                {{ $title }}
            </h3>
        </div>

        {{-- Instructions --}}
        <div class="space-y-4">
            @foreach ($instructions as $instruction)
                <div class="flex gap-4 items-start">
                    {{-- Step --}}
                    <div
                        class="shrink-0 w-9 h-9 flex items-center justify-center
                               rounded-full bg-sky-500 text-white
                               font-bold text-sm">
                        {{ $loop->iteration }}
                    </div>

                    {{-- Content --}}
                    <div
                        class="flex-1 bg-white dark:bg-gray-800
                               p-4 rounded-lg shadow-sm">
                        <div class="text-sm text-gray-800 dark:text-gray-200 leading-relaxed">
                            {!! $instruction !!}
                        </div>
                    </div>
                </div>
            @endforeach
        </div>

    </div>
@endif
