@props([
    'type' => 'text',
    'variant' => 'outline', // outline or filled
    'size' => 'md', // sm, md, lg
    'label' => null,
    'placeholder' => '',
    'viewable' => false, // 👁 enable password toggle
    'error' => null
])

@php
    $wireModel = collect($attributes->getAttributes())->keys()->first(fn($key) => str_starts_with($key, 'wire:model'));

    if ($wireModel) {
        $field = $attributes->get($wireModel);
        $error = $errors->first($field);
    }
    $baseWrapper = 'relative rounded-md';

    $baseInput = 'block w-full rounded-md border bg-white text-gray-900 placeholder:text-gray-400
                  dark:bg-[#2F2F2F] dark:text-gray-100 dark:placeholder:text-zinc-400
                  focus:outline-none focus:ring-2 transition-colors duration-200 ease-in-out';

    $variants = [
        'outline' => 'border-gray-300 focus:border-primary-500 focus:ring-primary-500
                      dark:border-gray-600 dark:focus:border-primary-400 dark:focus:ring-primary-400',
        'filled' => 'border-transparent bg-gray-100 focus:border-primary-500 focus:bg-white focus:ring-primary-500
                     dark:bg-gray-700 dark:focus:border-primary-400 dark:bg-gray-800 dark:focus:ring-primary-400'
    ];

    $sizes = [
        'sm' => 'px-2 py-1 text-sm',
        'md' => 'px-4 py-2 text-base',
        'lg' => 'px-6 py-3 text-lg'
    ];

    $sizeHeight = match ($size) {
        'sm' => 'h-8 py-1.5 text-sm leading-[1.125rem] rounded-md',
        'md' => 'h-10 py-2 text-base sm:text-sm leading-[1.375rem] rounded-lg',
        'lg' => 'h-12 py-3 text-lg leading-[1.625rem] rounded-lg',
        default => 'h-10 py-2 text-base sm:text-sm leading-[1.375rem] rounded-lg'
    };

    // Add right padding if viewable icon exists
    $extraPadding = $type === 'password' && $viewable ? 'pr-10' : '';

    $inputClasses = collect([
        $baseInput,
        $variants[$variant] ?? $variants['outline'],
        $sizes[$size] ?? $sizes['md'],
        $sizeHeight,
        $extraPadding,
        'shadow-xs border',
        'bg-white dark:bg-white/10 dark:disabled:bg-white/[7%]',
        'text-zinc-700 dark:text-zinc-300 disabled:text-zinc-500 dark:disabled:text-zinc-400',
        $error
            ? 'border-red-500 focus:ring-red-500 focus:border-red-500 dark:border-red-400 dark:focus:ring-red-400 dark:focus:border-red-400'
            : 'border border-zinc-200 border-b-zinc-300/80 dark:border-white/10'
    ])->implode(' ');
@endphp

@if ($label)
    <label class="block mb-2 text-sm font-medium text-gray-700 dark:text-gray-200">
        {{ $label }}
    </label>
@endif

<div class="{{ $baseWrapper }}" @if ($type === 'password' && $viewable) x-data="{ show: false }" @endif>
    <input :type="{{ $type === 'password' && $viewable ? 'show ? \'text\' : \'password\'' : "'$type'" }}"
        placeholder="{{ $placeholder }}" {{ $attributes->merge(['class' => $inputClasses]) }}>

    {{-- 👁 Eye Toggle --}}
    @if ($type === 'password' && $viewable)
        <button type="button" @click="show = !show"
            class="absolute inset-y-0 right-3 flex items-center text-zinc-400 hover:text-zinc-600 dark:hover:text-zinc-300"
            tabindex="-1">
            <x-flux::icon x-show="!show" name="eye" class="h-5 w-5" />
            <x-flux::icon x-show="show" name="eye-slash" class="h-5 w-5" />
        </button>
    @endif
</div>

@if ($error)
    <p class="mt-1 text-sm text-red-600 dark:text-red-400 flex items-center gap-1">
        <x-flux::icon name="exclamation-circle" class="h-4 w-4" />
        {{ $error }}
    </p>
@endif
