@props([
    'cards' => [],
    'gridCols' => 3,
    'title' => '',
    'description' => '',
    'py' => 'py-8 md:py-12',
    'imgHeight' => true,
    'fixedHeight' => true, // New: optional min-height for cards
])

@php
    $gridClass = "sm:grid-cols-1 md:grid-cols-{$gridCols}";
$cardHeightClass = $fixedHeight ? 'sm:min-h-130' : '';
$cardImgHeightClass = $imgHeight ? 'sm:h-1/2' : '';
@endphp

<section class="relative {{ $py }} bg-gray-50 dark:bg-gray-900 border-t border-gray-200 dark:border-gray-800">
    <div class="relative z-10 max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 fade-in-up space-y-6">
       <div>
         @if ($title)
            <h2 class="text-sky-600 font-medium capitalize tracking-wide text-lg md:text-2xl">{{ $title }}</h2>
        @endif

        @if ($description)
            <p class="text-gray-700 dark:text-gray-300 text-sm md:text-base leading-relaxed">
                {!! nl2br(e($description)) !!}
            </p>
        @endif
       </div>

        <div class="grid gap-8 sm:grid-cols-2 md:{{ $gridClass }}">
            @foreach($cards as $card)
                <div  class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 overflow-hidden flex flex-col shadow-sm hover:shadow-md transition-shadow duration-300 group {{ $cardHeightClass }}">
                    
                    <!-- Top Image -->
                    <img src="{{ $card['image'] ?? 'https://via.placeholder.com/400x200' }}" 
                         alt="{{ $card['title'] ?? 'Card' }}" 
                         class="w-full {{ $cardImgHeightClass }} object-cover transform transition-transform ease-in-out duration-300 group-hover:scale-105">

                    <!-- Content -->
                    <div class="p-6 flex flex-col justify-between flex-1">
                        <div class="space-y-3">
                            <h2 class="text-2xl font-semibold text-gray-800 dark:text-gray-100">{{ $card['title'] ?? 'Card Title' }}</h2>

                            @if(!empty($card['description']))
                                <p class="text-gray-600 dark:text-gray-300 text-sm md:text-base">
                                    {!! nl2br(e($card['description'])) !!}
                                </p>
                            @endif

                       @if(!empty($card['list']) && is_array($card['list']))
    <ul class="mt-4 space-y-2 text-gray-700 dark:text-gray-300 text-sm font-medium capitalize">
        @foreach($card['list'] as $item)
            <li class="relative pl-4">
                <!-- Custom bullet -->
                <span class="absolute left-0 top-1/2 transform -translate-y-1/2 w-1.5 h-1.5 bg-red-800 rounded-md"></span>
                <!-- List content -->
                {!! nl2br(e($item)) !!}
            </li>
        @endforeach
    </ul>
@endif

                        </div>

                        <!-- Button -->
                        <a href="{{ $card['buttonLink'] ?? '#' }}"
                           class="mt-6 inline-flex items-center justify-center gap-2 py-3 px-5 rounded-lg border border-sky-700 text-sky-700 hover:bg-sky-700 hover:text-white transition-colors duration-200 font-medium">
                           {{ $card['buttonText'] ?? 'Learn More' }}
                           <x-flux::icon.arrow-right class="w-4 h-4"/>
                        </a>
                    </div>
                </div>
            @endforeach
        </div>
    </div>
</section>
