@props([
    'title' => '',
    'titleSize' => 'text-3xl sm:text-4xl lg:text-5xl',
    'badgeIcon' => 'currency-dollar',
    'quick' => '',
    'description' => '',
    'image' => '',               // image path
    'imageAlt' => '',
    'imagePosition' => 'right',  // 'left' or 'right'
    'buttonText' => '',
    'buttonLink' => '#',
    'benefits' => [],            // array of strings
    'badgeText' => '',           // optional badge text
    'bgLight' => 'bg-gray-50 dark:bg-gray-900', // section background
    'highlightColor' => 'text-sky-700 dark:text-sky-300', // text highlight / badge color
])

<section class="relative {{ $bgLight }} overflow-hidden py-8 md:py-12">
    <div class="relative z-10 max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 fade-in-up">

        <div class="grid lg:grid-cols-2 items-stretch bg-white dark:bg-gray-900 border border-gray-100 dark:border-gray-800">

            <!-- Image -->
            <div class="{{ $imagePosition === 'left' ? 'order-1 md:order-1' : 'order-1 md:order-2' }}">
                <div class="relative h-full w-full rounded-3xl overflow-hidden shadow-lg border border-gray-200 dark:border-gray-700">
                    <img src="{{ $image }}" alt="{{ $imageAlt }}" class="w-full h-full object-cover transition-transform duration-700 group-hover:scale-105">
                </div>
            </div>

            <!-- Content -->
            <div class="{{ $imagePosition === 'left' ? 'order-2 md:order-2' : 'order-2 md:order-1' }}">
                <div class="space-y-6 p-4 lg:p-8 transition-all duration-500 hover:shadow-lg hover:-translate-y-1 ">
                    
                    <!-- Optional Badge -->
                    @if(!empty($badgeText))
                        <div class="inline-flex items-center px-4 py-2 bg-sky-100 dark:bg-sky-900/20 {{ $highlightColor }} rounded-full text-sm font-bold mb-4 shadow-sm border border-sky-200/50 dark:border-sky-700/50">
                           <x-dynamic-component :component="'flux::icon.' . $badgeIcon" class="w-5 h-5 mr-2"/>
                            {{ $badgeText }}
                        </div>
                    @endif



                    @if($title)
                        <h2 class="{{ $titleSize }} font-bold text-gray-900 dark:text-gray-50 leading-tight">
                            {{ $title }}
                        </h2>
                    @endif

                 @if(isset($description) && $description)
    <p class="text-lg text-gray-700 dark:text-gray-300 leading-relaxed">
        {!! $description !!}
    </p>
@endif

{{-- New slot for rich description --}}
@if(isset($slot) && trim($slot) !== '')
    <div class="text-base text-gray-700 dark:text-gray-300 leading-relaxed space-y-4">
        {!! $slot !!}
    </div>
@endif


                    <!-- Benefits List -->
                    @if(!empty($benefits))
                        <div class="space-y-3 mt-4">
                            @foreach($benefits as $benefit)
                                <div class="flex items-center space-x-3">
                                    <div class="shrink-0 w-6 h-6 bg-sky-100 dark:bg-sky-900/30 rounded-full flex items-center justify-center">
                                        <x-flux::icon.check class="w-4 h-4 text-sky-600 dark:text-sky-400" />
                                    </div>
                                    <span class="text-gray-700 dark:text-gray-300 font-medium">{{ $benefit }}</span>
                                </div>
                            @endforeach
                        </div>
                    @endif

                    @if ($quick)
                        <h2 class="text-sm md:text-base text-primary-700 capitalize font-semibold tracking-wide">{{ $quick }}</h2>
                    @endif


                    <!-- Button -->
              @if ($buttonLink && $buttonText)
    <div class="mt-6">
        <a href="{{ $buttonLink }}"
           class="inline-flex items-center justify-center px-6 py-3 bg-white border border-sky-600 text-sky-600 font-semibold text-lg rounded-lg shadow-sm hover:bg-sky-50 hover:shadow-md transition duration-300 transform hover:-translate-y-0.5 focus:outline-none focus:ring-2 focus:ring-sky-400 focus:ring-offset-2">
            {{ $buttonText }}
            <svg class="w-5 h-5 ml-2 text-sky-600 transition-transform duration-300 group-hover:translate-x-1" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" d="M9 5l7 7-7 7" />
            </svg>
        </a>
    </div>
@endif

                </div>
            </div>
        </div>
    </div>
</section>
