@props([
    'subject' => 'Notification',
    'headerTitle' => config('app.name'),
    'headerUrl' => '#',
    'transaction' => null,
    'transactionMessage' => '',
    'url' => '#',
    'privacyPolicyUrl' => '#',
    'termsOfServiceUrl' => '#',
    'unsubscribeUrl' => '#',
])
<!DOCTYPE html>
<html lang="en" xmlns="http://www.w3.org/1999/xhtml">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{ $subject }}</title>
    <style>
        body {
            margin: 0;
            padding: 0;
            background-color: #f5f7fa;
            font-family: Arial, sans-serif;
            -webkit-text-size-adjust: none;
        }

        a {
            text-decoration: none;
            transition: all 0.3s ease;
        }

        @media(prefers-color-scheme: dark) {
            body {
                background-color: #0a0a0a;
                color: #ffffff;
            }

            table {
                background-color: #121212 !important;
            }
        }
    </style>
</head>

<body>
    <table role="presentation" width="100%" cellpadding="0" cellspacing="0" style="padding:40px 0;">
        <tr>
            <td align="center">
                <table role="presentation" width="600" cellpadding="0" cellspacing="0"
                    style="width:100%; max-width:600px; background-color:#ffffff; border-radius:12px; box-shadow:0 6px 20px rgba(0,0,0,0.08); overflow:hidden;">

                    <!-- Header -->
                    <tr>
                        <td align="center" style="background-color:#002b5c; padding:24px 0;">
                            <a href="{{ $headerUrl ?? '#' }}" style="text-decoration:none;">
                                <h1
                                    style="margin:0; font-weight:800; font-size:22px; color:#ffffff; letter-spacing:1px;">
                                    {{ strtoupper($headerTitle ?? config('app.name')) }}
                                </h1>
                            </a>
                        </td>
                    </tr>

                    <!-- Main Content -->
                    <tr>
                        <td style="padding:40px; color:#333333;">{!! $slot !!}
                        </td>
                    </tr>

                    <!-- Footer -->
                    <tr>
                        <td align="center" style="padding: 20px 40px 40px 40px; font-size: 12px; color: #999;">
                            <p style="margin:0;">&copy;
                                {{ date('Y') }}
                                {{ config('app.name') }}
                                . All rights reserved.
                            </p>

                            <p style="margin: 5px 0 10px 0;"> <a href="{{ $privacyPolicyUrl ?? '#' }}"
                                    style="color:#999; text-decoration: underline;">Privacy Policy</a>
                                |
                                <a href="{{ $termsOfServiceUrl ?? '#' }}"
                                    style="color:#999; text-decoration: underline;">Terms of
                                    Service</a>
                                |
                                <a href="{{ $unsubscribeUrl ?? '#' }}"
                                    style="color:#999; text-decoration: underline;">Unsubscribe</a>
                            </p>
                        </td>
                    </tr>

                </table>
            </td>
        </tr>
    </table>
</body>

</html>
