@props(['fields', 'fieldValues', 'dynamicUploads'])

{{-- Dynamic Fields --}}
@if (!empty($fields))
    <div class="grid grid-cols-1 sm:grid-cols-2 gap-4">
        @foreach ($fields as $field)
            @php
                $fieldName = $field['name'];
                $fieldType = $field['type'];
                $fieldLabel = $field['label'] ?? ucfirst(str_replace('_', ' ', $fieldName));

                // Make textarea and file fields span full width
                $colClass = in_array($fieldType, ['textarea', 'file']) ? 'col-span-2' : 'col-span-1';

                // Generate placeholder dynamically from field name
                $placeholder = $field['placeholder'] ?? 'Enter ' . strtolower($fieldLabel);
            @endphp

            <div class="{{ $colClass }}">
                @if ($fieldType === 'textarea')
                    <flux:textarea wire:model.defer="fieldValues.{{ $fieldName }}" label="{{ $fieldLabel }}"
                        placeholder="{{ $placeholder }}" />
                @elseif ($fieldType === 'select')
                    <flux:select wire:model="fieldValues.{{ $fieldName }}" label="{{ $fieldLabel }}">
                        <option value="" disabled>Select {{ $fieldLabel }}
                        </option>
                        @foreach ($field['options'] ?? [] as $option)
                            <option value="{{ $option['value'] }}">
                                {{ $option['label'] }}
                            </option>
                        @endforeach
                    </flux:select>
                @elseif ($fieldType === 'file')
                    <x-ui.custom-file-upload :model="'dynamicUploads.' . $fieldName" :label="$fieldLabel" accepted-file-types="image/*"
                        :placeholder="$placeholder" />
                @else
                    <flux:input wire:model.defer="fieldValues.{{ $fieldName }}" label="{{ $fieldLabel }}"
                        type="{{ $fieldType }}" placeholder="{{ $placeholder }}" />
                @endif
            </div>
        @endforeach
    </div>
@endif
