@props(['title', 'value', 'badge' => null, 'icon', 'color' => 'blue'])

@php
    $bgColors = [
        'blue' => 'bg-blue-600',
        'green' => 'bg-green-600',
        'red' => 'bg-red-600',
        'yellow' => 'bg-yellow-500',
        'indigo' => 'bg-indigo-600',
        'purple' => 'bg-purple-600'
    ];

    $textColors = [
        'blue' => 'text-blue-600 dark:text-blue-400',
        'green' => 'text-green-600 dark:text-green-400',
        'red' => 'text-red-600 dark:text-red-400',
        'yellow' => 'text-yellow-600 dark:text-yellow-400',
        'indigo' => 'text-indigo-600 dark:text-indigo-400',
        'purple' => 'text-purple-600 dark:text-purple-400'
    ];

    $bgColor = $bgColors[$color] ?? $bgColors['blue'];
    $textColor = $textColors[$color] ?? $textColors['blue'];
@endphp

<div
    class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 relative hover:shadow-lg transition-shadow duration-200 space-y-2 py-3 px-3">

    <!-- Icon -->
    <div
        class="shrink-0 w-10 h-10 rounded-lg flex items-center justify-center
               {{ $bgColor }} shadow-md">
        <flux:icon name="{{ $icon }}" class="w-5 h-5 text-white" />
    </div>

    <!-- Text Content -->
    <div class="flex-1 flex flex-col gap-1">
        <h3 class="text-xl font-semibold text-gray-900 dark:text-white wrap-break-word">
            {{ $value }}
        </h3>
        <p class="text-sm text-gray-500 dark:text-gray-300 wrap-break-word">
            {{ $title }}
        </p>
    </div>

    <!-- Badge (absolute) -->
    @if ($badge)
        <span
            class="absolute top-0 right-0 px-3 py-1 rounded-full 
                   bg-gray-200/80 dark:bg-zinc-700/80 
                   text-gray-800 dark:text-gray-200 text-xs font-medium {{ $textColor }}">
            {{ $badge }}
        </span>
    @endif
</div>
