@props([
    'primaryLinkText' => 'Open Savings Account',
    'primaryLinkUrl' => '#',
])

<div class="bg-linear-to-r from-sky-700 via-sky-600 to-sky-800 w-full py-12">
    <div class="max-w-6xl mx-auto text-center space-y-6 px-4 sm:px-6 lg:px-8 fade-in-up">
        <h2 class="text-sm md:text-base lg:text-3xl text-white font-bold uppercase">
            Ready to Bank with Us?
        </h2>
        <p class="text-white text-sm md:text-base leading-relaxed max-w-2xl mx-auto">
            Let's discuss how we can support your business growth and financial success.
        </p>

        <!-- CTA Buttons -->
        <div class="mt-6 flex flex-col sm:flex-row justify-center gap-4">
            
            <!-- Primary CTA passed as props -->
            <a href="{{ $primaryLinkUrl }}" class="flex items-center justify-center gap-2 px-5 py-3 bg-white text-primary-600 font-semibold rounded-full shadow hover:bg-gray-100 transition-colors duration-300">
                <x-flux::icon.briefcase variant="solid" class="w-5 h-5" />
                <span>{{ $primaryLinkText }}</span>
            </a>

            <!-- Constant phone CTA -->
         <a href="tel:{{ config('app.phone') }}" 
   class="flex items-center justify-center gap-2 px-5 py-3 border border-white text-white font-semibold rounded-full hover:bg-white hover:text-primary-600 transition-colors duration-300">
    <x-flux::icon.phone variant="solid" class="w-5 h-5" />
    <span>Speak with Advisor</span>
</a>

        </div>
    </div>
</div>
