@props(['label', 'options' => [], 'columns' => 2, 'error' => null])

@php
    $gridCols = match ((int) $columns) {
        1 => 'grid-cols-1',
        2 => 'grid-cols-1 md:grid-cols-2',
        3 => 'grid-cols-1 md:grid-cols-3',
        4 => 'grid-cols-1 md:grid-cols-4',
        default => 'grid-cols-1 md:grid-cols-2',
    };
@endphp

<div class="space-y-2">
    <fieldset>
        <legend id="{{ $attributes->get('id', 'checkbox-card-group') }}"
            class="text-sm font-medium text-gray-900 dark:text-gray-100">
            {{ $label }}
        </legend>

        <div class="grid {{ $gridCols }} gap-4 mt-3" role="group"
            aria-labelledby="{{ $attributes->get('id', 'checkbox-card-group') }}">
            @foreach ($options as $option)
                <label
                    class="group relative flex gap-4 p-4 rounded-xl border cursor-pointer
                           transition-all duration-200 ease-out
                           bg-white dark:bg-zinc-900
                           border-gray-200 dark:border-zinc-700
                           hover:border-sky-500 dark:hover:border-sky-400
                           focus-within:ring-2 focus-within:ring-sky-500
                           has-[:checked]:border-sky-600
                           has-[:checked]:bg-sky-50 dark:has-[:checked]:bg-sky-900/20
                           has-[:checked]:shadow-md
                           has-[:checked]:scale-[1.01]">
                    <!-- Input -->
                    <input type="checkbox" {{ $attributes->whereStartsWith('wire:model') }} value="{{ $option['value'] }}"
                        class="sr-only" aria-describedby="{{ $option['value'] }}-desc" />

                    <!-- Icon (optional) -->
                    @if (!empty($option['icon']))
                        <div class="flex h-10 w-10 shrink-0 items-center justify-center rounded-full
                                   bg-sky-500/15 text-sky-600
                                   transition-all duration-200
                                   group-has-[:checked]:bg-sky-600
                                   group-has-[:checked]:text-white"
                            aria-hidden="true">
                            <x-flux::icon :name="$option['icon']" variant="solid" class="h-5 w-5" />
                        </div>
                    @endif

                    <!-- Content -->
                    <div class="space-y-0.5">
                        <p class="font-medium text-gray-900 dark:text-gray-100">
                            {{ $option['title'] }}
                        </p>
                        <p id="{{ $option['value'] }}-desc" class="text-sm text-gray-600 dark:text-gray-400">
                            {{ $option['description'] ?? '' }}
                        </p>
                    </div>

                    <!-- Check indicator -->
                    <div class="absolute top-3 right-3 hidden h-5 w-5 items-center justify-center
                               rounded-full bg-sky-600 text-white
                               group-has-[:checked]:flex
                               transition-transform duration-200 scale-90 group-has-[:checked]:scale-100"
                        aria-hidden="true">
                        <x-flux::icon.check variant="solid" class="h-3 w-3" />
                    </div>
                </label>
            @endforeach
        </div>
    </fieldset>

    <!-- Validation Error -->
    @if ($error && $errors->has($error))
        <p class="mt-1 text-sm text-red-600 dark:text-red-400 flex items-center gap-1">
            <x-flux::icon name="exclamation-circle" class="h-4 w-4" />
            {{ $errors->first($error) }}
        </p>
    @endif
</div>
