@props([
    'variant' => 'primary',
    'size' => 'md',
    'type' => 'button',
    'icon' => null,
    'iconVariant' => null,
    'iconPosition' => 'left',
])

@php
    $base =
        'peer rounded font-medium transition-colors focus:outline-none focus:ring-2 focus:ring-offset-2 data-loading:opacity-50 data-loading:pointer-events-none';
    $variants = [
        'primary' => 'bg-sky-600 text-white hover:bg-sky-700 focus:ring-sky-500',
        'secondary' => 'bg-gray-200 text-gray-800 hover:bg-gray-300 focus:ring-gray-400',
        'danger' => 'bg-red-600 text-white hover:bg-red-700 focus:ring-red-500',
        'subtle' =>
            'bg-gray-50 text-gray-700 hover:bg-gray-100 focus:ring-gray-300 dark:bg-gray-700 dark:text-gray-200 dark:hover:bg-gray-600 dark:focus:ring-gray-500',
    ];

    $sizes = [
        'sm' => 'px-2 py-1 text-sm',
        'md' => 'px-4 py-2 text-base',
        'lg' => 'px-6 py-3 text-lg',
    ];

    $classes = trim(
        $base . ' ' . ($variants[$variant] ?? $variants['primary']) . ' ' . ($sizes[$size] ?? $sizes['md']),
    );

    $iconClasses = $iconVariant ? $variants[$iconVariant] ?? '' : '';
    $iconFirst = $icon && $iconPosition === 'left';
    $iconLast = $icon && $iconPosition === 'right';
@endphp

<button type="{{ $type }}" {{ $attributes->class($classes) }}>
    <span class="not-in-data-loading:flex items-center gap-2 justify-center text-xs sm:text-sm in-data-loading:hidden">
        @if ($iconFirst)
            <flux:icon name="{{ $icon }}" class="w-4 h-4 {{ $iconClasses }}" />
        @endif

        {{ $slot }}

        @if ($iconLast)
            <flux:icon name="{{ $icon }}" class="w-4 h-4 {{ $iconClasses }}" />
        @endif
    </span>

    <span class="hidden in-data-loading:inline-flex items-center space-x-2">
        <flux:icon.loading class="w-4 h-4 animate-spin" />
    </span>
</button>
