@props([
    'configKey' => null, // e.g., 'about_us'
])

@php
    // Start with Home link
    $breadcrumbs = [
        ['title' => 'Home', 'route' => 'home', 'icon' => 'home'] // icon key for the home icon
    ];

    if ($configKey && config("navigation.{$configKey}")) {
        $nav = config("navigation.{$configKey}");
        
        // Add parent menu
        $breadcrumbs[] = [
            'title' => $nav['title'],
            'route' => $nav['items'][0]['route'] ?? null
        ];

        // Determine current item
        foreach ($nav['items'] as $item) {
            if (!empty($item['route']) && request()->routeIs($item['route'] . '*')) {
                $breadcrumbs[] = ['title' => $item['name']];
                break;
            }
        }
    }
@endphp

<nav class="text-sm text-gray-500 dark:text-gray-400 py-3 bg-gray-50 dark:bg-gray-800" aria-label="Breadcrumb">
    <ol class="list-none p-0 inline-flex items-center space-x-3">
        @foreach($breadcrumbs as $index => $link)
            @php
                $isLast = $index === count($breadcrumbs) - 1;
            @endphp
            <li class="inline-flex items-center space-x-1">
                @if(!$isLast)
                    <a href="{{ isset($link['route']) ? route($link['route']) : '#' }}"
                       class="flex items-center px-2 py-1 rounded-md hover:bg-gray-100 dark:hover:bg-gray-800 transition-colors duration-150">
                        @if(isset($link['icon']) && $link['icon'] === 'home')
                            <x-flux::icon.home class="w-4 h-4 mr-1 text-gray-400 dark:text-gray-500"/>
                        @endif
                        <span class="hover:text-primary-600 dark:hover:text-sky-400">{{ $link['title'] }}</span>
                    </a>
                    <svg class="w-4 h-4 text-gray-400" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" clip-rule="evenodd" d="M7.293 14.707a1 1 0 010-1.414L11.586 9 7.293 4.707a1 1 0 111.414-1.414l5 5a1 1 0 010 1.414l-5 5a1 1 0 01-1.414 0z"/>
                    </svg>
                @else
                    <span class="flex items-center px-2 py-1 text-gray-700 dark:text-gray-200 font-medium rounded-md">
                        {{ $link['title'] }}
                    </span>
                @endif
            </li>
        @endforeach
    </ol>
</nav>
