@props([
    'title' => '',
    'benefitGroups' => [], // Array of cards: ['title' => '', 'items' => [], 'bgColor' => '', 'subtitle' => '']
    'bulletColor' => 'bg-red-800', // default bullet color
    'banner' => '',
    'description' => '',
    'gridCols' => 3,
])

@php
    $gridClass = "sm:grid-cols-1 md:grid-cols-{$gridCols}";
@endphp

<section class="relative bg-gray-50 dark:bg-gray-900 overflow-hidden py-12">
    <div class="relative z-10 max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 space-y-8 fade-in-up">

        <!-- Section Title -->
        <div class="space-y-4">
            <h2 class="text-primary-600 text-3xl md:text-4xl tracking-wide font-semibold">
                {{ $title }}
            </h2>

     @if ($description)
                <p class="text-sm font-medium capitalize">{{ $description }}</p>
     @endif
        </div>

        <!-- Benefits Grid -->
        <div class="grid gap-8 {{ $gridClass }}">
            @foreach($benefitGroups as $group)
                <div class="flex flex-col h-full rounded-lg overflow-hidden shadow-sm hover:shadow-md transition-shadow duration-300">

                    <!-- Header -->
                    <h3 class="text-white text-center px-4 py-4 font-medium text-lg md:text-2xl {{ $group['bgColor'] ?? 'bg-sky-900' }}">
                        {{ $group['title'] ?? 'Benefit Category' }}
                    </h3>

                    <!-- Items -->
                    <ul class="flex flex-col gap-1 list-none py-5 px-4 bg-gray-200 dark:bg-gray-800 flex-1">
                            <!-- Optional Subtitle -->
                    @if (!empty($group['subtitle']))
                        <h4 class="text-primary-700 text-center px-4 py-2 text-sm md:text-base font-medium">
                            {{ $group['subtitle'] }}
                        </h4>
                    @endif
                        @foreach($group['items'] ?? [] as $item)
                            @if(is_array($item))
                                {{-- Nested list --}}
                                <li class="flex flex-col gap-2">
                                    <div class="flex items-start gap-3">
                                        <span class="w-2 h-2 rounded-full {{ $bulletColor }} mt-2 shrink-0"></span>
                                        <span class="text-gray-700 dark:text-gray-300 text-sm md:text-base leading-relaxed">
                                            {!! $item['text'] ?? '' !!}
                                        </span>
                                    </div>
                                    @if(!empty($item['subitems']))
                                        <ul class="list-none pl-6 space-y-1">
                                            @foreach($item['subitems'] as $subitem)
                                                <li class="">
                                                      <div class="flex items-start gap-2">
                                        <span class="w-1.5 h-1.5 rounded-full {{ $bulletColor }} mt-2 shrink-0"></span>
                                        <span class="text-gray-700 dark:text-gray-300 text-sm font-medium leading-relaxed">
                                       {!! $subitem !!}
                                        </span>
                                    </div>
                                                </li>

                                      
                                            @endforeach
                                        </ul>
                                    @endif
                                </li>
                            @else
                                {{-- Single item --}}
                                <li class="flex items-start gap-3">
                                    <span class="w-2 h-2 rounded-full {{ $bulletColor }} mt-2 shrink-0"></span>
                                    <span class="text-gray-700 dark:text-gray-300 text-sm md:text-base leading-relaxed">
                                        {!! $item !!}
                                    </span>
                                </li>
                            @endif
                        @endforeach
                    </ul>
                </div>
            @endforeach
        </div>

        {{-- Banner --}}
        @if ($banner)
            <p class="text-sm font-bold italic text-sky-800">
                {!! nl2br(e($banner)) !!}
            </p>
        @endif

    </div>
</section>
