@props([
    'title' => 'Beneficiaries',
    'beneficiaries' => [],
    'selectedBeneficiary' => null, // Livewire property
])

<div x-cloak x-data="{ openModal: null }"
    class="rounded-xl p-4 shadow-sm dark:shadow-gray-900/25 border border-gray-100 dark:border-gray-700">

    <!-- Heading -->
    <div class="flex items-center justify-between text-gray-800 dark:text-gray-200 mb-4">
        <h3 class="text-base font-semibold text-gray-900 dark:text-white">{{ $title }}</h3>
    </div>

    <!-- Beneficiaries Grid -->
    <div class="grid grid-cols-2 md:grid-cols-4 gap-4">

        <!-- Add Beneficiary Card -->
        <div @click="openModal = 'add-beneficiary'"
            class="flex flex-col items-center p-3 rounded-lg border border-dashed border-gray-300 dark:border-gray-600 
                    bg-gray-50 dark:bg-gray-700 cursor-pointer transition hover:ring hover:ring-sky-200 dark:hover:ring-sky-700">
            <div class="w-10 h-10 bg-sky-600 rounded-lg flex items-center justify-center mb-2">
                <x-flux::icon.plus class="w-5 h-5 text-white" />
            </div>
            <span class="text-xs font-medium text-gray-700 dark:text-gray-300 truncate">Add Beneficiary</span>
        </div>

        <!-- Existing Beneficiaries -->
        @foreach ($beneficiaries as $b)
            <div wire:click="$set('selectedBeneficiary', '{{ $b['id'] }}')"
                :class="$wire.selectedBeneficiary == '{{ $b['id'] }}' ?
                    'border-sky-600 ring ring-sky-200 dark:ring-sky-700' : 'border-gray-200 dark:border-gray-700'"
                class="flex flex-col p-3 rounded-lg border bg-gray-50 dark:bg-gray-700 cursor-pointer transition hover:ring hover:ring-sky-200 dark:hover:ring-sky-700">

                <div class="flex items-center justify-between mb-2">
                    <span
                        class="font-medium text-sm text-gray-700 dark:text-gray-200 truncate">{{ $b['name'] }}</span>
                    @if ($selectedBeneficiary == $b['id'])
                        <x-flux::icon.check class="w-4 h-4 text-green-500" />
                    @endif
                </div>

                <div class="text-xs text-gray-500 dark:text-sky-200 truncate">Acct: {{ $b['account_number'] }}</div>
                <div class="text-xs text-gray-500 dark:text-sky-200 truncate">Bank: {{ $b['bank'] }}</div>
                <div class="text-xs text-gray-400 dark:text-gray-300 truncate">{{ $b['nickname'] ?? '-' }}</div>
            </div>
        @endforeach
    </div>

    <!-- Add Beneficiary Modal -->
    <x-modal x-show="openModal === 'add-beneficiary'" @close="openModal = null">
        <h2 class="text-lg font-semibold mb-4">Add Beneficiary</h2>

        <div class="grid grid-cols-1 sm:grid-cols-2 gap-4">
            <x-flux::input wire:model.lazy="newBeneficiary.account_number" label="Account Number" type="number"
                placeholder="Account Number" />
            <x-flux::input wire:model.lazy="newBeneficiary.nickname" label="Nickname" type="text"
                placeholder="Nickname" />
        </div>

        <div class="mt-4 flex justify-end gap-2">
            <button type="button" @click="openModal = null; $wire.reset('newBeneficiary')"
                class="px-3 py-1 rounded bg-gray-200 dark:bg-gray-600 text-gray-700 dark:text-gray-300">
                Cancel
            </button>
            <button type="button" wire:click="addBeneficiary()" @click="openModal = null"
                class="px-3 py-1 rounded bg-sky-600 text-white hover:bg-sky-700">
                Save Beneficiary
            </button>
        </div>
    </x-modal>
</div>
