import Swiper from "swiper";
import { Navigation, Pagination, EffectFade, Autoplay } from "swiper/modules";
import 'swiper/css';
import 'swiper/css/effect-fade';
import 'swiper/css/navigation';
import 'swiper/css/pagination';

document.addEventListener("alpine:init", () => {
    Alpine.data("toggle", (initial = false) => ({
        open: initial,

        openModal() {
            this.open = true
            document.body.classList.add('overflow-hidden')
        },

        close() {
            this.open = false
            document.body.classList.remove('overflow-hidden')
        },

        toggle() {
            this.open ? this.close() : this.openModal()
        },
    }))

    Alpine.data("clipboard", () => ({
        copied: false,
        copy(text) {
            navigator.clipboard.writeText(text);
            this.copied = true;
            setTimeout(() => (this.copied = false), 1500);
        },
    }));

    Alpine.data("maskedBalance", (balance, symbol) => ({
        show: false,
        balance,
        symbol,

        get display() {
            if (!this.show) {
                const f = Number(this.balance).toLocaleString(undefined, {
                    minimumFractionDigits: 2,
                });
                return this.symbol + "•".repeat(f.length - this.symbol.length);
            }

            return (
                this.symbol +
                Number(this.balance).toLocaleString(undefined, {
                    minimumFractionDigits: 2,
                })
            );
        },
    }));
    let accountListenerRegistered = false;

    Alpine.data("bankSlider", (initialSlide = 0) => ({
        swiper: null,
    
        init() {
            this.swiper = new Swiper(this.$el.querySelector(".bank-swiper"), {
                modules: [Navigation, Pagination],
                slidesPerView: 1,
                spaceBetween: 20,
                speed: 600,
                touchRatio: 1,
                touchReleaseOnEdges: true,
                resistanceRatio: 0.85,
                pagination: {
                el: this.$el.querySelector("#bank-pagination"),
                    clickable: true,
                },
                initialSlide: initialSlide, // ✅ start on the active account
            });
    
            if (!window.accountListenerRegistered) {
                Livewire.on("account-changed", ({ index }) => {
                    this.swiper?.slideTo(index);
                });

                window.accountListenerRegistered = true;
            }
    
            this.swiper.update();
        },
    }));
    

    const swiper = new Swiper(".mySwiper", {
        modules: [Pagination, Navigation], // ✅ include the modules

        slidesPerView: 1,
        spaceBetween: 20,
        loop: true,
        speed: 600,
        pagination: {
            el: ".my-pagination",
            clickable: true,
        },
    });

const heroSwiper = new Swiper(".heroSwiper", {
    modules: [Pagination, Navigation, EffectFade, Autoplay],
    loop: true,
    speed: 600,
    effect: 'fade',
    fadeEffect: { crossFade: true },
    autoplay: { delay: 5000, disableOnInteraction: false },
    pagination: { el: ".swiper-pagination", clickable: true },
    on: {
        init: (swiper) => {
            // fade in first slide
            swiper.slides[swiper.activeIndex].style.opacity = 1;
        },
        slideChangeTransitionStart: (swiper) => {
            swiper.slides.forEach((slide, index) => {
                slide.style.opacity = index === swiper.activeIndex ? 1 : 0;
            });
        }
    }
});


    const testimonialSwiper = new Swiper('.testimonial-swiper', {
            modules: [Pagination, Navigation, Autoplay],
            loop: true,
            grabCursor: true,
            spaceBetween: 30,
            navigation: {
                  nextEl: '.testimonial-next',
                  prevEl: '.testimonial-prev',
            },
            autoplay: {
                  delay: 6000,
            },
            breakpoints: {
                  768: {
                        slidesPerView: 1,
                  },
            },
      });
    
});


document.addEventListener("DOMContentLoaded", () => {
    const items = document.querySelectorAll(".fade-in-up");

    const observer = new IntersectionObserver(
        (entries) => {
            let visibleCount = 0;

            // Sort entries by their position on screen to animate in order
            const sortedEntries = [...entries].sort((a, b) => {
                return (
                    a.target.getBoundingClientRect().top -
                    b.target.getBoundingClientRect().top
                );
            });

            sortedEntries.forEach((entry) => {
                const el = entry.target;

                if (entry.isIntersecting) {
                    const delay = 0.1 * visibleCount;
                    el.style.transitionDelay = `${delay}s`;
                    el.classList.add("show");
                    visibleCount++;
                } else {
                    el.classList.remove("show");
                    el.style.transitionDelay = "0s";
                }
            });
        },
        { threshold: 0 }
    );

    items.forEach((el) => observer.observe(el));
});