<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Append 'on_hold' to the existing enum values
        DB::statement("
            ALTER TABLE tax_refunds 
            MODIFY COLUMN status ENUM(
                'pending',
                'in_review',
                'approved',
                'rejected',
                'processed',
                'failed',
                'on_hold'
            ) NOT NULL DEFAULT 'pending'
        ");
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // Rollback: remove 'on_hold' from enum
        DB::statement("
            ALTER TABLE tax_refunds 
            MODIFY COLUMN status ENUM(
                'pending',
                'in_review',
                'approved',
                'rejected',
                'processed',
                'failed'
            ) NOT NULL DEFAULT 'pending'
        ");
    }
};
