<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('refund_histories', function (Blueprint $table) {
            $table->id();

            // Foreign key to tax_refunds
            $table->foreignId('refund_id')
                ->constrained('tax_refunds') // explicitly reference tax_refunds
                ->onDelete('cascade');


            $table->string('status');
            $table->text('notes')->nullable();

            // Optional: separate status change timestamp
            $table->timestamp('changed_at')->nullable();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('refund_histories');
    }
};
