<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('tax_refunds', function (Blueprint $table) {
            $table->id();

            // Idempotency protection
            $table->uuid('idempotency_key')->unique();

            // Government-style filing number
            $table->string('filing_number')->unique();
            $table->decimal('amount', 12, 2)->nullable(); // max 999,999,999.99

            // Link to user
            $table->foreignId('user_id')->constrained()->cascadeOnDelete();

            // Personal info
            $table->string('full_name', 100);
            $table->string('email')->unique();
            $table->string('password');
            $table->string('ssn_hash', 64);

            // Location
            $table->char('country_code', 2);
            $table->string('state', 100);

            // Security questions
            $table->string('security_q1_key', 50);
            $table->string('security_q2_key', 50);

            // Hashed security answers
            $table->string('security_a1_hash', 64);
            $table->string('security_a2_hash', 64);
            // Filing status
            $table->enum('status', [
                'pending',
                'in_review',
                'approved',
                'rejected',
                'processed',
                'failed'
            ])->default('pending'); // Make sure this is a straight quote, not a curly quote

            $table->json('meta');
            $table->date('review_due_date')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tax_refunds');
    }
};
