<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::table('transactions', function (Blueprint $table) {
            // Add transfer_id foreign key (assuming 'transfers' table exists)
            $table->foreignId('transfer_id')
                ->nullable()
                ->after('deposit_id')
                ->constrained()
                ->cascadeOnDelete();

            // Add crypto_balance_id foreign key pointing to the correct table
            $table->foreignId('crypto_balance_id')
                ->nullable()
                ->after('transfer_id')
                ->constrained('account_crypto_balances')  // <- specify correct table
                ->cascadeOnDelete();

            $table->index(['transfer_id', 'crypto_balance_id']);
        });
    }

    public function down(): void
    {
        Schema::table('transactions', function (Blueprint $table) {
            // Drop index FIRST
            $table->dropIndex(['transfer_id', 'crypto_balance_id']);

            // Drop foreign keys individually
            $table->dropForeign('transactions_transfer_id_foreign');
            $table->dropForeign('transactions_crypto_balance_id_foreign');

            // Drop columns
            $table->dropColumn(['transfer_id', 'crypto_balance_id']);
        });
    }
};
