<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('beneficiaries', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->cascadeOnDelete(); // Owner of the beneficiary
            $table->enum('type', ['international', 'local']);
            $table->string('account_number')->nullable();
            $table->string('nickname')->nullable(); // Optional nickname
            $table->json('meta')->nullable(); // Optional extra info

            $table->unique(['user_id', 'account_number']); // prevent duplicates per user
            $table->index('type');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('beneficiaries');
    }
};
