<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('crypto_fiat_swaps', function (Blueprint $table) {
            $table->id();
            $table->uuid('idempotency_key')->unique();
            $table->foreignId('account_id')->constrained();
            $table->foreignId('crypto_balance_id')->constrained('account_crypto_balances');
            $table->string('crypto_code');      // BTC
            $table->string('network');          // bitcoin
            $table->decimal('crypto_amount', 18, 8);
            $table->decimal('rate', 18, 8);
            $table->decimal('fiat_amount', 18, 2);
            $table->string('status');           // pending | completed | failed
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('crypto_fiat_swaps');
    }
};
