<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('account_crypto_balances', function (Blueprint $table) {
            $table->id();

            $table->foreignId('account_id')
                ->constrained()
                ->cascadeOnDelete();

            $table->string('code')->nullable();        // btc, usdt, eth
            $table->string('network')->nullable();     // btc, erc20, trc20

            $table->string('balance');            // total crypto
            $table->string('locked_balance');     // reserved

            $table->boolean('is_active')->default(true);
            $table->timestamps();

            $table->unique(['account_id', 'code', 'network']);
        });

    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('account_crypto_balances');
    }
};
