<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('withdrawals', function (Blueprint $table) {
            $table->id();
            $table->foreignId('account_id')->constrained()->cascadeOnDelete();
            $table->foreignId('payment_method_id')->constrained()->cascadeOnDelete(); // same table
            $table->uuid('idempotency_key')->unique();
            $table->decimal('amount', 16, 2)->default(0);
            $table->decimal('fee', 8, 2)->default(0);
            $table->decimal('total', 16, 2)->default(0);
            $table->json('meta')->nullable(); // e.g., bank account, PayPal email
            $table->enum('status', ['pending', 'approved', 'rejected', 'processing'])->default('pending');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('withdrawals');
    }
};
