<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('kycs', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->onDelete('cascade'); // link to users table

            // Track type/version of KYC
            $table->string('id_type')->nullable();       // passport, national ID, driver license
            $table->string('id_number')->nullable();
            $table->json('id_document_paths')->nullable();

            $table->string('address')->nullable();
            $table->string('address_document_path')->nullable();

            $table->enum('status', ['pending', 'verified', 'rejected'])->default('pending');
            $table->text('rejection_reason')->nullable();
            $table->json('data')->nullable();

            $table->timestamp('verified_at')->nullable();
            $table->unsignedInteger('version')->default(1); // track multiple submissions
            $table->boolean('is_latest')->default(true);    // mark which KYC is the current one

            $table->timestamps();

            // Optional: ensure only one "latest" per user
            $table->index('user_id');
            $table->index(['user_id', 'is_latest']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('kycs');
    }
};

