<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('accounts', function (Blueprint $table) {
            $table->decimal('per_transaction_limit', 15, 2)->default(100000)->after('reserve_balance');
            $table->decimal('daily_transaction_limit', 15, 2)->default(500000)->after('per_transaction_limit');
            $table->decimal('monthly_transaction_limit', 15, 2)->default(5000000)->after('daily_transaction_limit');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('accounts', function (Blueprint $table) {
            $table->dropColumn([
                'per_transaction_limit',
                'daily_transaction_limit',
                'monthly_transaction_limit',
            ]);
        });
    }
};
