<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('accounts', function (Blueprint $table) {
            $table->boolean('is_primary')
                ->default(false)
                ->after('profile_id');

            $table->boolean('is_active')
                ->default(false)
                ->after('is_primary'); // or after 'reserve_balance' if you removed is_primary


            $table->index(['profile_id', 'is_active', 'is_primary']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('accounts', function (Blueprint $table) {
            $table->dropIndex(['profile_id', 'is_active', 'is_primary']);
            $table->dropColumn('is_primary');
            $table->dropColumn('is_active');
        });
    }
};
