<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('transactions', function (Blueprint $table) {
            $table->id();
            // Link transaction to account
            $table->foreignId('account_id')->constrained()->onDelete('cascade')->nullable();
            $table->foreignId('deposit_id')->constrained()->onDelete('cascade')->nullable();
            $table->foreignId('referral_user_id')->nullable()->constrained('users')->nullOnDelete();
            $table->uuid('idempotency_key')->unique()->nullable();
            $table->enum('type', ['deposit', 'withdrawal', 'referral_bonus', 'signup_bonus', 'transfer_in', 'transfer_out', 'trade', 'loan', 'swap_credit', 'swap_debit']);
            $table->string('method')->nullable(); // wire, local, stripe, paypal, etc.            
            $table->decimal('amount', 15, 2);
            $table->decimal('balance_after', 15, 2);  // balance after transaction
            $table->string('description')->nullable(); // optional description
            $table->enum('status', ['pending', 'approved', 'rejected', 'review', 'cancelled', 'failed', 'completed']);
            $table->string('transaction_ref')->unique();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('transactions');
    }
};
