<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('deposits', function (Blueprint $table) {
            $table->id();
            $table->foreignId('account_id')->constrained()->onDelete('cascade'); // link to account
            $table->foreignId('payment_method_id')->constrained()->onDelete('cascade');
            $table->foreignId('crypto_wallet_id')->nullable()->constrained()->onDelete('set null'); // NEW
            $table->uuid('idempotency_key')->unique();
            $table->decimal('amount', 15, 2);
            $table->decimal('charge', 15, 2)->default(0);
            $table->decimal('total', 15, 2);
            $table->string('file_path'); // proof
            $table->string('status')->default('pending'); // pending, approved, rejected
            $table->json('meta')->nullable(); // store dynamic fields or extra info
            $table->timestamps();
        });
    }


    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('deposits');
    }
};
