<?php

return [

      // =========================================================
      // 1) ACCOUNTS & ONBOARDING (20)
      // =========================================================
      [
            'category' => 'Accounts & Onboarding',
            'question' => 'How do I open a new account?',
            'answer' => 'To open a new account, go to the Account Setup page and select the account type you want (Checking, Savings, Business, or Investment). You will be asked to provide your basic details, verify your identity, and confirm your contact information.

Once your account is approved, you can immediately access your dashboard, generate your account number, and begin funding your account through transfers, deposits, or supported payment methods.

If your account requires additional verification, you will see a clear status update in your dashboard with the next steps.',
            'is_active' => true,
      ],
      [
            'category' => 'Accounts & Onboarding',
            'question' => 'What information do I need to create an account?',
            'answer' => 'To create an account, you typically need your legal name, email address, phone number, date of birth, and residential address. In some cases, we may also request additional identity verification details to meet regulatory requirements.

For business accounts, you may be required to provide business registration details, ownership information, and proof of authorization to open the account.

We only request the minimum information needed to protect your account and comply with financial regulations.',
            'is_active' => true,
      ],
      [
            'category' => 'Accounts & Onboarding',
            'question' => 'Can I open more than one account?',
            'answer' => 'Yes, you can open multiple accounts depending on your needs. Many customers maintain separate accounts for spending, savings, business operations, or specific financial goals.

If your profile supports multiple accounts, you will be able to add new accounts from your dashboard and switch between them easily.

Some account types may require additional review before approval, especially if they involve higher limits or special features.',
            'is_active' => true,
      ],
      [
            'category' => 'Accounts & Onboarding',
            'question' => 'How long does it take to get approved?',
            'answer' => 'Most account applications are reviewed and approved within a short period, often within minutes. However, some applications may require manual verification depending on the details provided and compliance checks.

If manual review is needed, your dashboard will show your account status and any requested next steps.

Approval times may also vary depending on document clarity, regional requirements, and verification availability.',
            'is_active' => true,
      ],
      [
            'category' => 'Accounts & Onboarding',
            'question' => 'Why was my account application rejected?',
            'answer' => 'An application may be rejected if identity verification cannot be completed, if required documents are missing, or if the information provided does not match verification checks.

In some cases, regulatory compliance requirements may prevent us from offering services to certain applicants. These decisions are made to protect customers and comply with applicable laws.

If you believe your application was rejected in error, you can contact support for guidance on reapplying or correcting your details.',
            'is_active' => true,
      ],
      [
            'category' => 'Accounts & Onboarding',
            'question' => 'Can I upgrade my account type later?',
            'answer' => 'Yes. If you start with a basic account, you can request an upgrade later depending on eligibility. Upgrading may unlock additional features such as higher limits, premium services, or expanded account options.

Upgrades typically require an additional verification step to ensure the account remains secure and compliant.

Once approved, your account will reflect the updated type and benefits in your dashboard automatically.',
            'is_active' => true,
      ],
      [
            'category' => 'Accounts & Onboarding',
            'question' => 'Can I open an account if I live outside the country?',
            'answer' => 'Availability depends on your country of residence and applicable financial regulations. Some regions are supported fully, while others may have limited access to certain services.

If your country is supported, you will be able to complete onboarding with standard identity verification. If your country is not supported, you may not be able to proceed past the registration stage.

We recommend checking the supported regions list or contacting support for clarification.',
            'is_active' => true,
      ],
      [
            'category' => 'Accounts & Onboarding',
            'question' => 'Do you offer business accounts?',
            'answer' => 'Yes, business accounts are available for eligible customers. Business accounts are designed to support business transactions, invoicing, payroll, and structured reporting.

To open a business account, you may need to provide business registration information, ownership details, and proof of authorization.

Once approved, you can manage business finances separately from personal accounts, making tracking and accounting significantly easier.',
            'is_active' => true,
      ],
      [
            'category' => 'Accounts & Onboarding',
            'question' => 'How do I verify my identity?',
            'answer' => 'Identity verification is completed through a secure process where you provide required personal details and, where applicable, upload verification documents.

Depending on your region, we may request government-issued identification, proof of address, or a selfie verification to ensure the account belongs to you.

Verification is designed to protect you from fraud and ensure compliance with financial regulations.',
            'is_active' => true,
      ],
      [
            'category' => 'Accounts & Onboarding',
            'question' => 'What documents are accepted for verification?',
            'answer' => 'Accepted documents typically include government-issued IDs such as passports, national ID cards, or driver’s licenses. Proof of address may include utility bills, bank statements, or official letters.

Documents must be clear, valid, and not expired. The name and details must match your registration information.

If a document is not accepted, your dashboard will show the reason and allow you to submit an alternative.',
            'is_active' => true,
      ],
      [
            'category' => 'Accounts & Onboarding',
            'question' => 'Can I change my personal details after registration?',
            'answer' => 'Yes, you can update some personal details such as phone number and address through your profile settings. Certain fields like your legal name may require verification and support review.

This policy exists to prevent fraud and protect your account from unauthorized changes.

If you need to update restricted details, contact support and be prepared to provide documentation.',
            'is_active' => true,
      ],
      [
            'category' => 'Accounts & Onboarding',
            'question' => 'How do I close my account?',
            'answer' => 'To close your account, ensure your balance is zero and all pending transactions are completed. Then, submit an account closure request through support or your account settings.

Some accounts may require additional confirmation steps, especially if there are active cards, loans, disputes, or compliance reviews.

Once closed, your account may no longer be accessible, so ensure you download any statements or records you need first.',
            'is_active' => true,
      ],
      [
            'category' => 'Accounts & Onboarding',
            'question' => 'Can I reopen a closed account?',
            'answer' => 'In most cases, closed accounts cannot be reopened. However, you may be able to create a new account using the same identity if eligible.

If your account was closed due to inactivity, it may be possible to restore access depending on your region and policy.

For the best guidance, contact support with your registered email address.',
            'is_active' => true,
      ],
      [
            'category' => 'Accounts & Onboarding',
            'question' => 'Do you support joint accounts?',
            'answer' => 'Joint accounts may be supported depending on the product and region. If joint accounts are available, both individuals will need to complete identity verification and agree to the terms.

Joint accounts allow shared access, shared balances, and shared transaction history.

If joint accounts are not currently available, you may still be able to create separate accounts and transfer funds between them.',
            'is_active' => true,
      ],
      [
            'category' => 'Accounts & Onboarding',
            'question' => 'Can I set up an account for a minor?',
            'answer' => 'Minor accounts are only available where legally permitted and may require a parent or guardian to manage the account.

If minor accounts are supported, additional documentation and consent may be required to ensure compliance with applicable laws.

If not supported, we recommend opening a standard account once the individual meets the minimum age requirement.',
            'is_active' => true,
      ],
      [
            'category' => 'Accounts & Onboarding',
            'question' => 'What account types do you offer?',
            'answer' => 'We offer several account types depending on your region, including Checking, Savings, Business, and specialized financial service accounts.

Each account type includes different limits, fees, and features. You can compare account types directly during the account setup process.

If you are unsure which account to choose, support can recommend the best option based on your needs.',
            'is_active' => true,
      ],
      [
            'category' => 'Accounts & Onboarding',
            'question' => 'Will I get an account number immediately?',
            'answer' => 'In most cases, yes. Once your account is approved, your account number and routing details will be generated and visible in your dashboard.

Some account types may require additional steps before full account details are available.

If your account details are pending, your dashboard will clearly indicate what is required to complete activation.',
            'is_active' => true,
      ],
      [
            'category' => 'Accounts & Onboarding',
            'question' => 'Do you provide monthly statements?',
            'answer' => 'Yes. Monthly statements are available for most account types and can be accessed in your dashboard under Statements or Documents.

Statements include transaction history, balances, and relevant account details for the selected period.

You can download statements for recordkeeping, tax purposes, or personal financial tracking.',
            'is_active' => true,
      ],
      [
            'category' => 'Accounts & Onboarding',
            'question' => 'Is there a minimum balance requirement?',
            'answer' => 'Minimum balance requirements depend on the account type and region. Some accounts have no minimum balance, while others may require a minimum balance to avoid certain fees.

You can view your account’s balance rules in your dashboard or in the account terms provided during signup.

We recommend reviewing the fees and limits section for your specific account type.',
            'is_active' => true,
      ],
      [
            'category' => 'Accounts & Onboarding',
            'question' => 'How do I add another account type to my profile?',
            'answer' => 'To add another account, go to your dashboard and select Add Account. Choose the account type and complete any required verification steps.

If you already have an account of the same type, the system may prevent duplicates depending on product rules.

Once added, you can switch between accounts directly in your dashboard without logging out.',
            'is_active' => true,
      ],

      // =========================================================
      // 2) LOGIN, SECURITY & VERIFICATION (20)
      // =========================================================
      [
            'category' => 'Login, Security & Verification',
            'question' => 'I forgot my password. How do I reset it?',
            'answer' => 'To reset your password, click “Forgot Password” on the login page and follow the instructions sent to your registered email address.

For security, password reset links expire after a short time and can only be used once.

If you do not receive the email, check your spam folder or confirm that you are using the correct email address.',
            'is_active' => true,
      ],
      [
            'category' => 'Login, Security & Verification',
            'question' => 'Why am I not receiving the verification code?',
            'answer' => 'Verification codes may be delayed due to network issues, email provider filtering, or SMS delivery delays. First, check your spam folder if the code is sent by email.

If you are using SMS, confirm that your phone number is correct and that your device has signal.

If the issue persists, you can request a new code or contact support to confirm your account contact details.',
            'is_active' => true,
      ],
      [
            'category' => 'Login, Security & Verification',
            'question' => 'How do I enable two-factor authentication (2FA)?',
            'answer' => 'You can enable 2FA from your Security Settings. Once enabled, you will be required to enter a verification code during login in addition to your password.

2FA significantly improves account security by preventing unauthorized access even if your password is compromised.

We strongly recommend enabling 2FA for all users, especially for accounts that handle payments, transfers, or card services.',
            'is_active' => true,
      ],
      [
            'category' => 'Login, Security & Verification',
            'question' => 'Can I use an authenticator app instead of SMS?',
            'answer' => 'If authenticator app support is available, you can enable it in your Security Settings. Authenticator apps are generally more reliable than SMS and offer stronger security.

Once configured, you will scan a QR code and store backup recovery codes in a safe place.

If you lose access to your authenticator device, recovery codes may be required to regain access.',
            'is_active' => true,
      ],
      [
            'category' => 'Login, Security & Verification',
            'question' => 'What should I do if I think my account was hacked?',
            'answer' => 'If you suspect unauthorized access, immediately change your password and enable 2FA if it is not already enabled.

Next, review your recent login activity and transaction history for any unfamiliar actions. If you see suspicious transactions, contact support immediately.

We may temporarily restrict account activity while we investigate to protect your funds and personal information.',
            'is_active' => true,
      ],
      [
            'category' => 'Login, Security & Verification',
            'question' => 'Why was my account temporarily locked?',
            'answer' => 'Accounts may be temporarily locked after multiple failed login attempts or suspicious login activity. This is a security measure designed to protect your account from brute-force attacks.

In most cases, the lock will automatically expire after a short period, or you may unlock the account using a verification step.

If you cannot regain access, support can assist after confirming your identity.',
            'is_active' => true,
      ],
      [
            'category' => 'Login, Security & Verification',
            'question' => 'How do I change my password?',
            'answer' => 'You can change your password from your Profile or Security Settings. For best security, choose a long password that is unique and not used on other websites.

After updating your password, you may be logged out of other devices as a protective measure.

If you did not request the password change, contact support immediately.',
            'is_active' => true,
      ],
      [
            'category' => 'Login, Security & Verification',
            'question' => 'Do you track login activity?',
            'answer' => 'Yes. For security purposes, we record login activity such as device type, approximate location, and timestamps.

This helps detect suspicious activity and allows you to review where your account has been accessed.

If you notice an unfamiliar login, you should change your password immediately and enable 2FA.',
            'is_active' => true,
      ],
      [
            'category' => 'Login, Security & Verification',
            'question' => 'Can I log in from multiple devices?',
            'answer' => 'Yes, you can log in from multiple devices. However, we may request verification when a new device is detected.

This protects your account by ensuring only authorized devices can access your banking dashboard.

If you no longer use a device, we recommend logging out and removing it from your trusted device list if available.',
            'is_active' => true,
      ],
      [
            'category' => 'Login, Security & Verification',
            'question' => 'How do I update my phone number?',
            'answer' => 'You can update your phone number in your Profile Settings. Depending on your account security level, we may require verification before the change is applied.

Phone number updates are treated as high-risk changes because they affect verification and recovery methods.

If you cannot access your old number, support can assist after identity verification.',
            'is_active' => true,
      ],
      [
            'category' => 'Login, Security & Verification',
            'question' => 'How do I update my email address?',
            'answer' => 'Email address updates can be completed in your profile settings. For security, you may need to confirm the change through a verification link.

Your email is an important account identifier and is used for alerts, statements, and recovery.

If you suspect someone changed your email without permission, contact support immediately.',
            'is_active' => true,
      ],
      [
            'category' => 'Login, Security & Verification',
            'question' => 'Why do you require identity verification?',
            'answer' => 'Identity verification helps protect your account from fraud and ensures compliance with financial regulations such as anti-money laundering requirements.

It also ensures that the account belongs to the person who claims ownership, preventing impersonation and unauthorized access.

Verification requirements vary by region and product type.',
            'is_active' => true,
      ],
      [
            'category' => 'Login, Security & Verification',
            'question' => 'What happens if my verification fails?',
            'answer' => 'If verification fails, you will be notified and given the opportunity to resubmit documents or correct your information.

Common reasons include blurry images, expired documents, mismatched names, or incomplete submissions.

If repeated attempts fail, support can review your case and guide you through the correct process.',
            'is_active' => true,
      ],
      [
            'category' => 'Login, Security & Verification',
            'question' => 'Do you store my verification documents?',
            'answer' => 'Verification documents are handled securely and stored only as required for compliance and fraud prevention. Access is restricted and monitored.

We use industry-standard safeguards to protect sensitive information.

Retention periods depend on regulatory requirements and may vary by jurisdiction.',
            'is_active' => true,
      ],
      [
            'category' => 'Login, Security & Verification',
            'question' => 'How do I recover my account if I lose access to my email?',
            'answer' => 'If you lose access to your email, contact support as soon as possible. You will be asked to verify your identity using alternative methods.

Account recovery may require document verification and additional confirmation to protect against fraud.

Once verified, support can help you update your contact details safely.',
            'is_active' => true,
      ],
      [
            'category' => 'Login, Security & Verification',
            'question' => 'How do I recover my account if I lose my phone?',
            'answer' => 'If you lose your phone, contact support immediately, especially if SMS verification is enabled. You may also be able to log in using backup codes if you enabled app-based 2FA.

Support will verify your identity before updating your phone number or disabling 2FA.

We recommend updating your phone number as soon as you have a replacement device.',
            'is_active' => true,
      ],
      [
            'category' => 'Login, Security & Verification',
            'question' => 'Can I disable 2FA?',
            'answer' => 'Yes, 2FA can usually be disabled in your security settings. However, disabling 2FA may require additional verification because it reduces account security.

If your account is high-risk or has certain services enabled, disabling 2FA may not be allowed without support review.

For best security, we strongly recommend keeping 2FA enabled.',
            'is_active' => true,
      ],
      [
            'category' => 'Login, Security & Verification',
            'question' => 'Do you support biometric login?',
            'answer' => 'Biometric login support depends on your device and platform. Where supported, biometric login provides a faster and secure way to access your account.

Biometrics are stored on your device and are not shared with us.

If biometric login is enabled, you can still use your password as a fallback.',
            'is_active' => true,
      ],
      [
            'category' => 'Login, Security & Verification',
            'question' => 'Why do you ask security questions?',
            'answer' => 'Security questions may be used as an additional layer of verification during sensitive actions or account recovery.

They help confirm identity when other verification methods are unavailable.

If security questions are enabled, you should choose answers that are not easy to guess and are not publicly available.',
            'is_active' => true,
      ],
      [
            'category' => 'Login, Security & Verification',
            'question' => 'How do I report phishing or suspicious emails?',
            'answer' => 'If you receive a suspicious email claiming to be from us, do not click links or download attachments. Forward the message to our support team for review.

We will investigate the email and advise you on next steps.

If you entered your login details on a suspicious site, change your password immediately and enable 2FA.',
            'is_active' => true,
      ],

      // =========================================================
      // 3) DEPOSITS & WITHDRAWALS (20)
      // =========================================================
      [
            'category' => 'Deposits & Withdrawals',
            'question' => 'How do I deposit money into my account?',
            'answer' => 'You can deposit funds using supported transfer methods such as bank transfer, internal transfer, or other deposit channels available in your region.

Once you initiate a deposit, you will receive a confirmation and you can track the deposit status in your transaction history.

If a deposit is delayed, it may be due to processing times, verification requirements, or bank network delays.',
            'is_active' => true,
      ],
      [
            'category' => 'Deposits & Withdrawals',
            'question' => 'How long do deposits take to reflect in my balance?',
            'answer' => 'Deposit processing times depend on the method used. Some deposits are instant, while others may take several hours or business days.

Transfers may be delayed due to bank processing schedules, weekends, holidays, or compliance checks.

You can always view the deposit status in your transaction history for transparency.',
            'is_active' => true,
      ],
      [
            'category' => 'Deposits & Withdrawals',
            'question' => 'Why is my deposit pending?',
            'answer' => 'A deposit may show as pending if it is still being processed by the payment network or requires verification checks.

Pending deposits are not yet available for withdrawal until processing completes.

If a deposit remains pending beyond the normal timeframe, contact support with the transaction reference number.',
            'is_active' => true,
      ],
      [
            'category' => 'Deposits & Withdrawals',
            'question' => 'Can I cancel a deposit?',
            'answer' => 'Most deposit transactions cannot be canceled once initiated, especially if the deposit is already in the banking network.

If the deposit was initiated internally and is still in a pending state, cancellation may be possible in some cases.

If you believe a deposit was made in error, contact support immediately for guidance.',
            'is_active' => true,
      ],
      [
            'category' => 'Deposits & Withdrawals',
            'question' => 'How do withdrawals work?',
            'answer' => 'Withdrawals allow you to move money from your account to an external bank, card, or supported payout method.

You can initiate a withdrawal from your dashboard by selecting the withdrawal method and entering the amount.

Withdrawals may be subject to limits, fees, and compliance checks depending on your account type and region.',
            'is_active' => true,
      ],
      [
            'category' => 'Deposits & Withdrawals',
            'question' => 'How long do withdrawals take?',
            'answer' => 'Withdrawal times vary depending on the payout method and banking network. Some withdrawals are processed quickly, while others may take 1–5 business days.

Processing may take longer during weekends, holidays, or when additional verification is required.

You can track withdrawal status in your transaction history.',
            'is_active' => true,
      ],
      [
            'category' => 'Deposits & Withdrawals',
            'question' => 'Why was my withdrawal rejected?',
            'answer' => 'Withdrawals may be rejected due to insufficient balance, incorrect payout details, account restrictions, or compliance checks.

Some withdrawals are blocked if your account is under review or if the destination account cannot be verified.

If your withdrawal was rejected, review the error message and contact support if needed.',
            'is_active' => true,
      ],
      [
            'category' => 'Deposits & Withdrawals',
            'question' => 'What are withdrawal limits?',
            'answer' => 'Withdrawal limits depend on your account type, verification level, and compliance profile. Limits may apply daily, weekly, or monthly.

Higher verification levels often allow higher limits.

You can view your current limits in your account settings or withdrawal screen.',
            'is_active' => true,
      ],
      [
            'category' => 'Deposits & Withdrawals',
            'question' => 'Do withdrawals have fees?',
            'answer' => 'Fees depend on the withdrawal method and your account type. Some withdrawals may be free, while others include processing fees.

Fees are always shown before you confirm the withdrawal so you can review the cost.

If a third-party bank charges additional fees, those charges are outside our control.',
            'is_active' => true,
      ],
      [
            'category' => 'Deposits & Withdrawals',
            'question' => 'Can I withdraw money to someone else’s bank account?',
            'answer' => 'In some cases, yes. However, withdrawals to third-party accounts may require additional verification and may be restricted based on compliance rules.

This is to prevent fraud and unauthorized transfers.

If you need to withdraw to a third party regularly, consider using approved beneficiary settings where available.',
            'is_active' => true,
      ],
      [
            'category' => 'Deposits & Withdrawals',
            'question' => 'What does “available balance” mean?',
            'answer' => 'Available balance is the amount of money you can currently spend or withdraw. It excludes reserved funds, pending transactions, and holds.

Reserved funds may include pending transfers, compliance holds, or amounts allocated to ongoing services.

Your dashboard shows both total balance and available balance for transparency.',
            'is_active' => true,
      ],
      [
            'category' => 'Deposits & Withdrawals',
            'question' => 'What does “reserved balance” mean?',
            'answer' => 'Reserved balance refers to funds that are temporarily locked and cannot be withdrawn or spent. This may occur due to pending transactions, disputes, compliance reviews, or service-related holds.

Reserved funds are still yours, but they are unavailable until the hold is released.

You can view reserved balance details in your account breakdown.',
            'is_active' => true,
      ],
      [
            'category' => 'Deposits & Withdrawals',
            'question' => 'Can deposits be reversed?',
            'answer' => 'Deposits can sometimes be reversed by the originating bank or payment provider if the transaction is disputed, flagged as fraudulent, or initiated incorrectly.

If a deposit is reversed, the amount may be removed from your balance and the transaction will show as reversed.

If you believe a reversal is incorrect, contact support with the transaction details.',
            'is_active' => true,
      ],
      [
            'category' => 'Deposits & Withdrawals',
            'question' => 'Why was my deposit reversed?',
            'answer' => 'Deposits may be reversed due to bank disputes, insufficient funds at the sender’s bank, chargebacks, compliance issues, or incorrect transaction details.

Reversals are usually initiated by the sender’s financial institution, not by us.

If you need more information, support can help review the transaction record and guide you on next steps.',
            'is_active' => true,
      ],
      [
            'category' => 'Deposits & Withdrawals',
            'question' => 'Can I deposit using a credit or debit card?',
            'answer' => 'Card deposits may be available depending on your region and account type. If supported, you can add a card and deposit funds instantly.

Card deposits may include processing fees and may be subject to additional verification checks.

If card deposits are not available, you can still deposit via bank transfer or other supported methods.',
            'is_active' => true,
      ],
      [
            'category' => 'Deposits & Withdrawals',
            'question' => 'Why is my card deposit failing?',
            'answer' => 'Card deposits may fail due to insufficient funds, card restrictions, incorrect card details, or issuer declines.

Some banks block online deposits or international transactions by default.

If your card deposit fails repeatedly, contact your card issuer or try an alternative deposit method.',
            'is_active' => true,
      ],
      [
            'category' => 'Deposits & Withdrawals',
            'question' => 'Do you support cash deposits?',
            'answer' => 'Cash deposits may be supported only through specific partner channels and in selected regions.

If cash deposits are available, your dashboard will show deposit instructions and authorized locations.

If not supported, you can deposit funds through bank transfer or other electronic methods.',
            'is_active' => true,
      ],
      [
            'category' => 'Deposits & Withdrawals',
            'question' => 'What should I do if my deposit is missing?',
            'answer' => 'If a deposit is missing, first confirm the transaction reference, amount, and destination account details. Then check your transaction history for pending or failed status.

If the deposit is not visible after the expected timeframe, contact support with proof of payment or bank confirmation.

Support can trace the deposit through the banking network and provide an update.',
            'is_active' => true,
      ],
      [
            'category' => 'Deposits & Withdrawals',
            'question' => 'Can I withdraw if my account is under review?',
            'answer' => 'If your account is under compliance review or verification review, withdrawals may be temporarily restricted.

This is a standard security measure designed to protect both you and the banking system from unauthorized or suspicious activity.

Once the review is completed, full withdrawal access is typically restored automatically.',
            'is_active' => true,
      ],

      // =========================================================
      // 4) TRANSFERS & PAYMENTS (20)
      // =========================================================
      [
            'category' => 'Transfers & Payments',
            'question' => 'How do I send money to another bank account?',
            'answer' => 'To send money, go to Transfers and choose Bank Transfer. Enter the recipient bank details, confirm the amount, and submit the transfer.

For security, some transfers may require additional verification, especially for large amounts or new recipients.

Once submitted, you can track the transfer status in your transaction history.',
            'is_active' => true,
      ],
      [
            'category' => 'Transfers & Payments',
            'question' => 'What is an internal transfer?',
            'answer' => 'An internal transfer is a transfer between accounts within the same platform. Internal transfers are usually faster and may be processed instantly.

This is useful when sending money to family members or other users on the platform.

Internal transfers may still be subject to limits and security checks depending on the account type.',
            'is_active' => true,
      ],
      [
            'category' => 'Transfers & Payments',
            'question' => 'How long do transfers take?',
            'answer' => 'Transfer times depend on the method used. Internal transfers are typically instant, while external bank transfers may take 1–5 business days.

Delays can occur due to bank processing schedules, weekends, holidays, or compliance review.

You can always monitor transfer status in your transaction list.',
            'is_active' => true,
      ],
      [
            'category' => 'Transfers & Payments',
            'question' => 'Can I schedule a transfer for later?',
            'answer' => 'If scheduled transfers are available, you can set a future date when creating a transfer. This is useful for recurring payments, rent, or planned financial management.

Scheduled transfers will be processed automatically on the selected date.

If your balance is insufficient at the time of processing, the transfer may fail or remain pending depending on policy.',
            'is_active' => true,
      ],
      [
            'category' => 'Transfers & Payments',
            'question' => 'Can I cancel a transfer?',
            'answer' => 'Transfers can only be canceled if they have not yet been processed. Internal transfers are often instant and cannot be canceled after completion.

External transfers may be cancelable if they are still pending.

If you need urgent cancellation, contact support immediately with the transfer reference.',
            'is_active' => true,
      ],
      [
            'category' => 'Transfers & Payments',
            'question' => 'What happens if I send money to the wrong bank details?',
            'answer' => 'If you send money to incorrect bank details, recovery may not be guaranteed. Bank transfers rely on the recipient details being accurate.

If the transfer is still pending, cancellation may be possible. If completed, support can assist in attempting recovery, but success depends on the receiving bank.

Always double-check recipient details before confirming a transfer.',
            'is_active' => true,
      ],
      [
            'category' => 'Transfers & Payments',
            'question' => 'Do you support international transfers?',
            'answer' => 'International transfers may be supported depending on your region and account type. If available, you will see international transfer options in your transfer menu.

International transfers may take longer and may include additional fees or exchange rates.

We recommend reviewing the full transfer breakdown before confirming.',
            'is_active' => true,
      ],
      [
            'category' => 'Transfers & Payments',
            'question' => 'How do exchange rates work for transfers?',
            'answer' => 'If a transfer involves currency conversion, the exchange rate will be shown before you confirm the transaction.

Rates may vary based on market conditions, liquidity, and partner banking networks.

Once you confirm, the conversion rate is locked for that transaction to ensure transparency.',
            'is_active' => true,
      ],
      [
            'category' => 'Transfers & Payments',
            'question' => 'Why is my transfer pending?',
            'answer' => 'A transfer may be pending due to bank processing, compliance checks, recipient verification, or network delays.

Pending transfers are not completed yet and may not be available to the recipient until processing finishes.

If a transfer remains pending beyond the expected timeframe, contact support for assistance.',
            'is_active' => true,
      ],
      [
            'category' => 'Transfers & Payments',
            'question' => 'Why did my transfer fail?',
            'answer' => 'Transfers can fail due to insufficient funds, invalid recipient details, bank rejection, compliance restrictions, or exceeded limits.

When a transfer fails, the system will typically return the funds to your available balance automatically.

If the reason is unclear, support can review the failure logs and advise you.',
            'is_active' => true,
      ],
      [
            'category' => 'Transfers & Payments',
            'question' => 'Can I add beneficiaries for faster payments?',
            'answer' => 'Yes, if beneficiary management is available, you can save recipients as beneficiaries to avoid entering details repeatedly.

Some beneficiaries may require verification before they can be used for large transfers.

Saving beneficiaries improves convenience while maintaining security controls.',
            'is_active' => true,
      ],
      [
            'category' => 'Transfers & Payments',
            'question' => 'How do I remove a beneficiary?',
            'answer' => 'You can remove a beneficiary from your Beneficiaries section. Removing a beneficiary does not affect past transfers, but prevents future transfers to that recipient.

For security, removal may require verification.

If you cannot remove a beneficiary, support can assist after identity confirmation.',
            'is_active' => true,
      ],
      [
            'category' => 'Transfers & Payments',
            'question' => 'Do you support bill payments?',
            'answer' => 'Bill payments may be supported depending on region. If available, you can pay utilities, subscriptions, or service providers directly from your account.

Bill payments can be one-time or recurring depending on the feature set.

You can track all bill payments in your transaction history.',
            'is_active' => true,
      ],
      [
            'category' => 'Transfers & Payments',
            'question' => 'Can I set up recurring payments?',
            'answer' => 'If recurring payments are available, you can schedule regular transfers weekly, monthly, or on custom intervals.

Recurring payments help you automate rent, savings, subscriptions, or business payouts.

You can edit or cancel recurring payments at any time from your scheduled payments section.',
            'is_active' => true,
      ],
      [
            'category' => 'Transfers & Payments',
            'question' => 'Why was my payment reversed?',
            'answer' => 'Payments may be reversed if the receiving bank rejects the transfer, if the recipient account is closed, or if compliance checks require reversal.

A reversed payment will usually return to your balance, though timing depends on banking network processing.

If you need confirmation, support can provide the full transaction status details.',
            'is_active' => true,
      ],
      [
            'category' => 'Transfers & Payments',
            'question' => 'Can I send money to someone without a bank account?',
            'answer' => 'In some regions, alternative payout methods may be available such as cash pickup, mobile wallet payout, or card payout.

If these methods are supported, they will appear as transfer options in your dashboard.

If not supported, the recipient will need a bank account or an internal account on the platform.',
            'is_active' => true,
      ],
      [
            'category' => 'Transfers & Payments',
            'question' => 'How do I confirm a transfer was successful?',
            'answer' => 'A transfer is confirmed successful when its status shows as Completed in your transaction history.

You can also download receipts or transaction confirmations where available.

If the recipient claims they did not receive funds but the transfer is completed, support can provide a trace reference for the receiving bank.',
            'is_active' => true,
      ],
      [
            'category' => 'Transfers & Payments',
            'question' => 'Can I get a transfer receipt?',
            'answer' => 'Yes. Most transfers include a downloadable receipt or transaction confirmation in your transaction history.

Receipts include key details such as amount, date, reference number, and recipient details.

Receipts are useful for recordkeeping, proof of payment, and dispute resolution.',
            'is_active' => true,
      ],
      [
            'category' => 'Transfers & Payments',
            'question' => 'Do transfers work on weekends?',
            'answer' => 'Internal transfers usually work on weekends. External bank transfers may be delayed depending on banking networks and processing schedules.

Even if you submit a transfer on a weekend, it may only be processed on the next business day.

Your transaction history will show when processing begins and when it completes.',
            'is_active' => true,
      ],

      // =========================================================
      // 5) CARDS (DEBIT / VIRTUAL / CREDIT) (20)
      // =========================================================
      [
            'category' => 'Cards (Debit / Virtual / Credit)',
            'question' => 'How do I request a debit card?',
            'answer' => 'To request a debit card, go to the Cards section in your dashboard and select Request Card.

You may be asked to confirm your delivery address and complete any required verification.

Once approved, you can track the card status and delivery updates directly from your account.',
            'is_active' => true,
      ],
      [
            'category' => 'Cards (Debit / Virtual / Credit)',
            'question' => 'Do you offer virtual cards?',
            'answer' => 'Yes, virtual cards may be available depending on your account type. Virtual cards are designed for online purchases and provide an extra layer of security.

You can generate a virtual card instantly and use it for subscriptions, online shopping, or digital payments.

Virtual cards can often be frozen or regenerated without affecting your physical card.',
            'is_active' => true,
      ],
      [
            'category' => 'Cards (Debit / Virtual / Credit)',
            'question' => 'How do I activate my card?',
            'answer' => 'Card activation can be done in your dashboard under Cards. Once activated, the card becomes available for use.

Some cards may require a first transaction using chip-and-PIN before contactless payments are enabled.

If activation fails, support can assist after verifying your identity.',
            'is_active' => true,
      ],
      [
            'category' => 'Cards (Debit / Virtual / Credit)',
            'question' => 'How do I freeze my card?',
            'answer' => 'You can freeze your card instantly in your dashboard. Freezing blocks new transactions but does not close your account.

This feature is useful if you suspect your card details may be compromised or if you temporarily misplace your card.

You can unfreeze the card at any time if the issue is resolved.',
            'is_active' => true,
      ],
      [
            'category' => 'Cards (Debit / Virtual / Credit)',
            'question' => 'How do I report a lost or stolen card?',
            'answer' => 'If your card is lost or stolen, freeze it immediately from your dashboard to prevent unauthorized transactions.

Next, report the issue through support so we can permanently block the card and issue a replacement.

If you notice unauthorized charges, file a dispute as soon as possible to improve recovery chances.',
            'is_active' => true,
      ],
      [
            'category' => 'Cards (Debit / Virtual / Credit)',
            'question' => 'How do I request a replacement card?',
            'answer' => 'Replacement cards can be requested in your Cards section. You will be asked to confirm your address and review any replacement fees if applicable.

Once requested, the old card may be deactivated to prevent misuse.

Delivery times vary by region, and you can track the replacement status in your dashboard.',
            'is_active' => true,
      ],
      [
            'category' => 'Cards (Debit / Virtual / Credit)',
            'question' => 'Why is my card transaction declined?',
            'answer' => 'Card transactions may be declined due to insufficient funds, merchant restrictions, incorrect PIN, exceeded limits, or security checks.

Some merchants also require additional verification for online payments.

If declines continue, check your card settings, confirm your balance, and contact support if needed.',
            'is_active' => true,
      ],
      [
            'category' => 'Cards (Debit / Virtual / Credit)',
            'question' => 'What are card spending limits?',
            'answer' => 'Card limits may apply daily, weekly, or monthly depending on your account type and verification level.

Limits exist to protect you from fraud and help manage financial risk.

You can view your current limits in your card settings and request an increase if eligible.',
            'is_active' => true,
      ],
      [
            'category' => 'Cards (Debit / Virtual / Credit)',
            'question' => 'Can I use my card internationally?',
            'answer' => 'International card usage may be supported depending on your card type and region. If supported, your card can be used for international purchases and withdrawals.

International usage may involve currency conversion and additional fees depending on the merchant and network.

If you plan to travel, review your card settings and ensure international transactions are enabled.',
            'is_active' => true,
      ],
      [
            'category' => 'Cards (Debit / Virtual / Credit)',
            'question' => 'How do currency conversions work for card purchases?',
            'answer' => 'When you make a purchase in a foreign currency, the card network converts the amount into your account currency.

Exchange rates are determined by the network and may include additional markups depending on card type.

The final amount is shown in your transaction history once the transaction is settled.',
            'is_active' => true,
      ],
      [
            'category' => 'Cards (Debit / Virtual / Credit)',
            'question' => 'Can I withdraw cash using my card?',
            'answer' => 'If ATM withdrawals are supported, you can withdraw cash using your debit card. Withdrawal limits and fees may apply.

Some ATMs may also charge their own fees, which are separate from our fees.

Always review withdrawal limits and available balance before attempting a cash withdrawal.',
            'is_active' => true,
      ],
      [
            'category' => 'Cards (Debit / Virtual / Credit)',
            'question' => 'Why is my ATM withdrawal failing?',
            'answer' => 'ATM withdrawals may fail due to insufficient balance, exceeded limits, incorrect PIN, ATM restrictions, or temporary network issues.

Some ATMs also block certain international cards or require chip-enabled transactions.

If the problem continues across multiple ATMs, contact support to review your card status.',
            'is_active' => true,
      ],
      [
            'category' => 'Cards (Debit / Virtual / Credit)',
            'question' => 'Can I change my card PIN?',
            'answer' => 'PIN changes may be available in your card settings or through supported ATM PIN services depending on region.

For security, PIN changes may require verification.

If you forgot your PIN, support can guide you through secure recovery or reset options.',
            'is_active' => true,
      ],
      [
            'category' => 'Cards (Debit / Virtual / Credit)',
            'question' => 'Do you support contactless payments?',
            'answer' => 'Yes, contactless payments may be supported depending on your card type. Contactless allows fast payments at supported terminals.

Some cards require a chip-and-PIN transaction before contactless is enabled.

If contactless does not work, try inserting the card and completing a chip transaction first.',
            'is_active' => true,
      ],
      [
            'category' => 'Cards (Debit / Virtual / Credit)',
            'question' => 'Can I use my card for online subscriptions?',
            'answer' => 'Yes. Cards can be used for subscriptions and online services. Virtual cards are especially recommended for subscriptions because they reduce risk.

If a subscription payment fails, ensure your card is active and has sufficient available balance.

You can view subscription-related transactions in your transaction history.',
            'is_active' => true,
      ],
      [
            'category' => 'Cards (Debit / Virtual / Credit)',
            'question' => 'What is a card authorization?',
            'answer' => 'A card authorization is a temporary hold placed by a merchant when you make a purchase. This hold reduces your available balance until the transaction is completed or released.

Authorizations are common for hotels, car rentals, and some online merchants.

If a merchant does not complete the transaction, the authorization may expire and the funds will return to your available balance.',
            'is_active' => true,
      ],
      [
            'category' => 'Cards (Debit / Virtual / Credit)',
            'question' => 'Why do I see duplicate charges?',
            'answer' => 'Duplicate charges may appear when a merchant places an authorization and then later posts the final charge separately.

In many cases, the authorization will drop off automatically after settlement.

If duplicate charges remain after a few business days, contact support and we will help review the transaction.',
            'is_active' => true,
      ],
      [
            'category' => 'Cards (Debit / Virtual / Credit)',
            'question' => 'How do refunds work on card payments?',
            'answer' => 'Refunds are initiated by the merchant and processed through the card network. Refund times vary depending on merchant and network processing.

Once the refund is completed, it will appear in your transaction history and balance.

If a refund is delayed beyond the normal timeframe, support can help trace it with the refund reference if available.',
            'is_active' => true,
      ],
      [
            'category' => 'Cards (Debit / Virtual / Credit)',
            'question' => 'Can I dispute a card transaction?',
            'answer' => 'Yes. If you believe a card transaction is unauthorized or incorrect, you can file a dispute through support.

Disputes require transaction details, and you may be asked to provide supporting information such as receipts or merchant communication.

We will review the dispute and work with the payment network where applicable.',
            'is_active' => true,
      ],

      // =========================================================
      // 6) LOANS & CREDIT SERVICES (20)
      // =========================================================
      [
            'category' => 'Loans & Credit Services',
            'question' => 'How do I apply for a loan?',
            'answer' => 'To apply for a loan, go to the Loans section and choose the loan type available to you. You will be asked to provide financial details, purpose, and supporting information.

Once submitted, your application may be reviewed automatically or manually depending on the amount and risk profile.

You can track the status of your loan application directly from your dashboard.',
            'is_active' => true,
      ],
      [
            'category' => 'Loans & Credit Services',
            'question' => 'What types of loans do you offer?',
            'answer' => 'Loan products vary by region and may include personal loans, salary advance loans, business loans, emergency loans, and secured credit services.

Each loan type includes different repayment terms, eligibility rules, and interest rates.

You can view available loan products and their requirements in your Loans section.',
            'is_active' => true,
      ],
      [
            'category' => 'Loans & Credit Services',
            'question' => 'How is loan eligibility determined?',
            'answer' => 'Eligibility is determined based on identity verification, account history, income indicators, transaction behavior, and compliance factors.

Some loans require a minimum account age or consistent account activity.

We aim to make eligibility checks fair, transparent, and compliant with financial regulations.',
            'is_active' => true,
      ],
      [
            'category' => 'Loans & Credit Services',
            'question' => 'How long does loan approval take?',
            'answer' => 'Some loans are approved quickly, while others require manual review. Approval time depends on the loan amount, risk profile, and required documentation.

If additional documents are required, you will be notified in your dashboard.

Once approved, loan funds are typically disbursed according to the product terms and banking network processing.',
            'is_active' => true,
      ],
      [
            'category' => 'Loans & Credit Services',
            'question' => 'Where do loan funds go after approval?',
            'answer' => 'Approved loan funds are usually deposited into your primary account balance or the account selected during the application.

Once disbursed, the funds become available based on standard processing rules.

If your loan includes a disbursement schedule, the dashboard will show each payout stage clearly.',
            'is_active' => true,
      ],
      [
            'category' => 'Loans & Credit Services',
            'question' => 'What are loan repayment options?',
            'answer' => 'Repayment options depend on the loan type. Many loans support automatic repayment from your account, manual payments, or scheduled repayment plans.

Automatic repayment helps prevent missed payments and late fees.

You can view your repayment schedule, due dates, and remaining balance in your loan dashboard.',
            'is_active' => true,
      ],
      [
            'category' => 'Loans & Credit Services',
            'question' => 'Can I repay my loan early?',
            'answer' => 'Early repayment is often allowed. Some loans may include early repayment fees, while others do not.

If early repayment is available, your dashboard will show the payoff amount and any applicable fees.

Paying early can reduce interest costs and improve your credit profile depending on the product.',
            'is_active' => true,
      ],
      [
            'category' => 'Loans & Credit Services',
            'question' => 'What happens if I miss a loan payment?',
            'answer' => 'Missed payments may result in late fees, account restrictions, or reporting consequences depending on the loan agreement.

We encourage customers to contact support if they anticipate payment difficulty, as alternative arrangements may be possible.

Repeated missed payments may lead to collections processes as permitted by law.',
            'is_active' => true,
      ],
      [
            'category' => 'Loans & Credit Services',
            'question' => 'How do you calculate interest?',
            'answer' => 'Interest calculation depends on the loan type and the agreement. Some loans use fixed interest, while others use variable rates.

Your loan terms clearly show how interest is calculated, the rate applied, and the repayment schedule.

You can also view a breakdown of principal and interest payments in your loan dashboard.',
            'is_active' => true,
      ],
      [
            'category' => 'Loans & Credit Services',
            'question' => 'Are there loan processing fees?',
            'answer' => 'Some loans include processing fees, origination fees, or service charges depending on the product.

Fees are disclosed before you confirm the loan agreement.

We encourage customers to review the full loan cost breakdown before accepting any loan offer.',
            'is_active' => true,
      ],
      [
            'category' => 'Loans & Credit Services',
            'question' => 'Can I apply for more than one loan?',
            'answer' => 'In some cases, yes. However, multiple loan applications may be restricted depending on your repayment capacity and risk profile.

If you have an active loan, you may need to repay part of it before applying for another.

Your dashboard will show whether additional loans are currently available to you.',
            'is_active' => true,
      ],
      [
            'category' => 'Loans & Credit Services',
            'question' => 'Why was my loan application rejected?',
            'answer' => 'Loan applications may be rejected due to eligibility checks, insufficient account history, missing documentation, or compliance requirements.

We also consider affordability indicators to ensure loans are offered responsibly.

If your application is rejected, you may be able to reapply later after improving eligibility factors.',
            'is_active' => true,
      ],
      [
            'category' => 'Loans & Credit Services',
            'question' => 'Can I change the loan amount after applying?',
            'answer' => 'Once submitted, loan applications typically cannot be edited. If you need a different amount, you may need to cancel and submit a new application.

This ensures accurate risk assessment and clear documentation.

If your application is still pending, support may be able to advise you on available options.',
            'is_active' => true,
      ],
      [
            'category' => 'Loans & Credit Services',
            'question' => 'Can I refinance my loan?',
            'answer' => 'Refinancing availability depends on your loan type and region. If supported, refinancing may allow you to adjust the repayment term or interest rate.

Refinancing requires a new review and eligibility assessment.

If refinancing is available, it will appear as an option in your loan dashboard.',
            'is_active' => true,
      ],
      [
            'category' => 'Loans & Credit Services',
            'question' => 'What is a credit limit?',
            'answer' => 'A credit limit is the maximum amount you can borrow or use under a credit service product.

Credit limits are based on eligibility, account history, verification level, and risk scoring.

Your credit limit may increase over time if you maintain good repayment behavior and consistent account activity.',
            'is_active' => true,
      ],
      [
            'category' => 'Loans & Credit Services',
            'question' => 'How do I increase my credit limit?',
            'answer' => 'Credit limit increases may be offered automatically based on account activity and repayment performance.

In some cases, you can request a review for a higher limit through your dashboard.

Additional verification or supporting documentation may be required for large limit increases.',
            'is_active' => true,
      ],
      [
            'category' => 'Loans & Credit Services',
            'question' => 'Do loans affect my account limits?',
            'answer' => 'Yes, active loans may affect your account’s withdrawal, transfer, or spending limits depending on risk controls.

This is a standard risk management practice in banking to ensure repayment capacity.

Once the loan is repaid, normal limits may be restored automatically.',
            'is_active' => true,
      ],
      [
            'category' => 'Loans & Credit Services',
            'question' => 'Where can I see my repayment schedule?',
            'answer' => 'Your repayment schedule is available in your Loans dashboard. It shows due dates, amounts, and repayment status.

You can also view payment history and download loan statements where available.

If a repayment date changes due to processing rules, your dashboard will show the updated schedule clearly.',
            'is_active' => true,
      ],
      [
            'category' => 'Loans & Credit Services',
            'question' => 'Can I set up automatic loan repayment?',
            'answer' => 'Yes, automatic repayment is available for many loan products. Once enabled, repayments are deducted automatically from your account on the due date.

Automatic repayment helps prevent missed payments and reduces administrative stress.

You can enable, disable, or adjust repayment settings in your loan dashboard.',
            'is_active' => true,
      ],

      // =========================================================
      // 7) GRANTS & FINANCIAL ASSISTANCE (20)
      // =========================================================
      [
            'category' => 'Grants & Financial Assistance',
            'question' => 'What is a grant application in the platform?',
            'answer' => 'A grant application is a request for financial assistance offered through eligible programs. Grants are not loans and typically do not require repayment.

Grant applications may require documentation, eligibility verification, and a review process.

Your dashboard will show your grant status and any requested next steps.',
            'is_active' => true,
      ],
      [
            'category' => 'Grants & Financial Assistance',
            'question' => 'How do I apply for a grant?',
            'answer' => 'To apply for a grant, go to the Grants section and choose an available program. Complete the application form and submit any required documents.

Grant applications are reviewed based on program rules and eligibility requirements.

Once submitted, you can track progress and updates in your dashboard.',
            'is_active' => true,
      ],
      [
            'category' => 'Grants & Financial Assistance',
            'question' => 'Who is eligible for grants?',
            'answer' => 'Eligibility depends on the grant program. Some grants are based on income level, location, employment status, business type, or specific financial needs.

Each grant program provides a clear eligibility summary before you apply.

If you are unsure about eligibility, support can help explain requirements, but final approval depends on program review.',
            'is_active' => true,
      ],
      [
            'category' => 'Grants & Financial Assistance',
            'question' => 'How long does grant review take?',
            'answer' => 'Grant review times vary by program and application volume. Some grants are reviewed quickly, while others require manual verification and program committee approval.

You can view your current status and timeline updates in your dashboard.

If additional information is required, you will be notified and given a chance to submit missing details.',
            'is_active' => true,
      ],
      [
            'category' => 'Grants & Financial Assistance',
            'question' => 'Why is my grant application pending?',
            'answer' => 'A pending grant application means it is still under review. This may be due to verification checks, missing documents, or program review timelines.

Pending does not mean rejected. It simply means a decision has not yet been made.

If your application remains pending beyond the expected timeframe, support can provide an update.',
            'is_active' => true,
      ],
      [
            'category' => 'Grants & Financial Assistance',
            'question' => 'Can I edit my grant application after submission?',
            'answer' => 'In most cases, submitted grant applications cannot be edited. This protects the integrity of the review process.

If you need to correct an error, support may be able to reopen the application if it has not been reviewed yet.

If the application is already under review, you may need to submit a new application depending on the program.',
            'is_active' => true,
      ],
      [
            'category' => 'Grants & Financial Assistance',
            'question' => 'What documents are required for grant applications?',
            'answer' => 'Documents vary by grant program but may include proof of identity, proof of income, proof of residence, business registration documents, or supporting statements.

All documents must be valid, clear, and match your application details.

If a document is rejected, you will be notified and allowed to resubmit.',
            'is_active' => true,
      ],
      [
            'category' => 'Grants & Financial Assistance',
            'question' => 'How do I know if my grant was approved?',
            'answer' => 'If your grant is approved, you will receive a dashboard notification and the status will change to Approved.

Approved grants typically include a disbursement timeline and amount confirmation.

Once disbursed, the grant amount will appear in your transaction history and balance.',
            'is_active' => true,
      ],
      [
            'category' => 'Grants & Financial Assistance',
            'question' => 'How are grant funds disbursed?',
            'answer' => 'Grant funds are usually disbursed directly into your account balance. In some cases, funds may be disbursed in stages depending on program rules.

Disbursement timelines are displayed once approval is confirmed.

If disbursement is delayed, it may be due to compliance checks or funding schedule policies.',
            'is_active' => true,
      ],
      [
            'category' => 'Grants & Financial Assistance',
            'question' => 'Are grants taxable?',
            'answer' => 'Grant tax treatment depends on your country and the type of grant. Some grants may be considered taxable income, while others may not.

We recommend consulting a qualified tax professional for guidance.

We can provide transaction records and statements, but we cannot provide legal or tax advice.',
            'is_active' => true,
      ],
      [
            'category' => 'Grants & Financial Assistance',
            'question' => 'Can I apply for multiple grants?',
            'answer' => 'Some grant programs allow multiple applications, while others restrict applicants to one active application at a time.

Your dashboard will show which programs are available and whether you can apply again.

Submitting multiple applications may also increase review time depending on program capacity.',
            'is_active' => true,
      ],
      [
            'category' => 'Grants & Financial Assistance',
            'question' => 'Why was my grant rejected?',
            'answer' => 'Grant applications may be rejected if eligibility requirements are not met, documents are incomplete, or program funding is limited.

Rejection does not necessarily prevent future applications, depending on program rules.

If you need clarity, support can explain the general reason shown in your application status.',
            'is_active' => true,
      ],
      [
            'category' => 'Grants & Financial Assistance',
            'question' => 'Can I appeal a rejected grant?',
            'answer' => 'Some grant programs allow appeals, while others do not. If appeals are supported, your dashboard will show an appeal option.

Appeals usually require additional documentation or clarification.

Even if an appeal is not available, you may be able to reapply when new grant cycles open.',
            'is_active' => true,
      ],
      [
            'category' => 'Grants & Financial Assistance',
            'question' => 'What does “grant on hold” mean?',
            'answer' => 'A grant on hold means the application cannot move forward until additional information is provided or a compliance check is completed.

This status is often used when documents are missing, unclear, or require manual review.

Once the required issue is resolved, the application can return to review automatically.',
            'is_active' => true,
      ],
      [
            'category' => 'Grants & Financial Assistance',
            'question' => 'Do grants require identity verification?',
            'answer' => 'Yes. Identity verification is required for grants to prevent fraud and ensure funds are distributed to legitimate applicants.

Verification may include documents, address confirmation, or additional checks depending on the program.

If verification is incomplete, grant disbursement may be delayed until it is resolved.',
            'is_active' => true,
      ],
      [
            'category' => 'Grants & Financial Assistance',
            'question' => 'Can grant funds be withdrawn immediately?',
            'answer' => 'In many cases, yes. However, grant funds may be subject to temporary holds depending on compliance rules and disbursement policy.

If a hold applies, your dashboard will show the reason and expected release timeline.

Once available, you can withdraw or transfer grant funds like normal balance.',
            'is_active' => true,
      ],
      [
            'category' => 'Grants & Financial Assistance',
            'question' => 'Can grant funds be used for anything?',
            'answer' => 'Some grants are unrestricted, while others are program-specific and may require funds to be used for a particular purpose such as business growth, education, or emergency needs.

Program rules are provided during the application process.

Misuse of restricted grants may result in restrictions or recovery actions depending on policy.',
            'is_active' => true,
      ],
      [
            'category' => 'Grants & Financial Assistance',
            'question' => 'Do you notify me when grant status changes?',
            'answer' => 'Yes. You will receive a dashboard notification when your grant status changes.

Depending on your notification settings, you may also receive email alerts.

We recommend keeping notifications enabled so you do not miss time-sensitive requests.',
            'is_active' => true,
      ],
      [
            'category' => 'Grants & Financial Assistance',
            'question' => 'Where can I see my grant history?',
            'answer' => 'Your grant history is available in the Grants section. You can view all applications, status changes, and disbursement records.

Historical records help with auditing, reporting, and tracking your financial assistance activity.

If you need statements, you can also download them from the Documents section where available.',
            'is_active' => true,
      ],

      // =========================================================
      // 8) TAX REFUND SERVICES (20)
      // =========================================================
      [
            'category' => 'Tax Refund Services',
            'question' => 'What is the tax refund service?',
            'answer' => 'The tax refund service helps you submit and track a tax refund-related request through your dashboard.

It is designed to provide structured filing details, document collection, status tracking, and secure communication during processing.

Your refund request progresses through statuses such as Pending, In Review, Approved, and Processed.',
            'is_active' => true,
      ],
      [
            'category' => 'Tax Refund Services',
            'question' => 'How do I start a tax refund request?',
            'answer' => 'To start a tax refund request, go to the Tax Refund section and select New Request. Complete the required details and submit any supporting documentation.

Once submitted, you will receive a filing reference and the request will appear in your dashboard.

You can track status changes and updates from the same section.',
            'is_active' => true,
      ],
      [
            'category' => 'Tax Refund Services',
            'question' => 'What does “pending” mean for tax refunds?',
            'answer' => 'Pending means your tax refund request has been submitted but has not yet been reviewed.

During pending status, the system may still be verifying required details and preparing your request for review.

If your request requires additional information, you may receive a notification before review begins.',
            'is_active' => true,
      ],
      [
            'category' => 'Tax Refund Services',
            'question' => 'What does “in review” mean for tax refunds?',
            'answer' => 'In Review means your request is actively being reviewed. This may include document verification, compliance checks, and confirmation of filing details.

This status indicates progress, but it does not guarantee approval.

If additional documents are required, you will be notified through your dashboard.',
            'is_active' => true,
      ],
      [
            'category' => 'Tax Refund Services',
            'question' => 'What does “approved” mean for tax refunds?',
            'answer' => 'Approved means your refund request has been accepted and the approved amount has been confirmed.

Approval typically happens after review and verification steps are completed.

Once approved, the request may move to Processed when the payout is completed.',
            'is_active' => true,
      ],
      [
            'category' => 'Tax Refund Services',
            'question' => 'What does “processed” mean for tax refunds?',
            'answer' => 'Processed means the refund payout has been completed and the transaction has been recorded.

If processed, you should see the funds in your account balance depending on payout rules.

If you do not see funds after processed status, contact support for payout tracing.',
            'is_active' => true,
      ],
      [
            'category' => 'Tax Refund Services',
            'question' => 'What does “on hold” mean for tax refunds?',
            'answer' => 'On Hold means your refund request cannot proceed until an issue is resolved. This may include missing documents, verification problems, or compliance review.

This status is used to protect your refund and ensure processing is accurate.

Once the issue is resolved, the request can move back into review.',
            'is_active' => true,
      ],
      [
            'category' => 'Tax Refund Services',
            'question' => 'Why would a tax refund be rejected?',
            'answer' => 'Tax refunds may be rejected if eligibility requirements are not met, documents are incomplete, verification fails, or compliance checks require rejection.

Rejection reasons vary and are typically displayed in your dashboard.

If you believe the rejection is incorrect, support can provide guidance on reapplying or correcting errors.',
            'is_active' => true,
      ],
      [
            'category' => 'Tax Refund Services',
            'question' => 'Can I submit multiple tax refund requests?',
            'answer' => 'Depending on policy, you may be allowed to submit multiple requests, especially if they relate to different filing periods or refund types.

However, multiple active requests may require additional review and may slow processing.

Your dashboard will show whether you can create a new request.',
            'is_active' => true,
      ],
      [
            'category' => 'Tax Refund Services',
            'question' => 'How do I upload tax refund documents?',
            'answer' => 'You can upload documents through the Tax Refund request page. Supported formats are usually PDF and image files.

Documents must be clear and complete. If a document is unclear, it may delay review.

If you upload the wrong file, you may be able to replace it depending on request status.',
            'is_active' => true,
      ],
      [
            'category' => 'Tax Refund Services',
            'question' => 'How do I know my refund filing number?',
            'answer' => 'Your filing number is generated automatically when you submit a refund request. It appears in your Tax Refund dashboard and request details page.

The filing number is used for tracking and support assistance.

We recommend saving it for reference if you need help later.',
            'is_active' => true,
      ],
      [
            'category' => 'Tax Refund Services',
            'question' => 'How long does tax refund processing take?',
            'answer' => 'Processing time depends on verification requirements, workload, and document completeness.

Some refunds progress quickly, while others require extended review due to compliance checks.

Your dashboard will show the current status and may show a review due date where applicable.',
            'is_active' => true,
      ],
      [
            'category' => 'Tax Refund Services',
            'question' => 'Can I update my tax refund information after submission?',
            'answer' => 'Once submitted, tax refund requests are typically locked to preserve review integrity.

If you need to correct an error, contact support immediately. If the request is still pending, edits may be possible.

If review has started, you may need to submit a new request depending on policy.',
            'is_active' => true,
      ],
      [
            'category' => 'Tax Refund Services',
            'question' => 'Do you notify me when my refund status changes?',
            'answer' => 'Yes. You will receive notifications when your refund status changes.

Depending on your settings, you may receive email notifications as well.

Notifications are designed to keep you updated and reduce the need for manual checking.',
            'is_active' => true,
      ],
      [
            'category' => 'Tax Refund Services',
            'question' => 'Can I withdraw a tax refund request?',
            'answer' => 'Some requests can be withdrawn if they are still pending. Once a request enters review, withdrawal may not be available.

If you need to withdraw a request, contact support immediately.

If the request is withdrawn, the filing will be closed and recorded in your history.',
            'is_active' => true,
      ],
      [
            'category' => 'Tax Refund Services',
            'question' => 'What happens if my tax refund fails?',
            'answer' => 'A refund may fail due to payout issues, incorrect destination details, or compliance restrictions.

If a refund fails, the status may change to Failed and you may receive instructions on next steps.

Support can assist in resolving payout issues and reprocessing where allowed.',
            'is_active' => true,
      ],
      [
            'category' => 'Tax Refund Services',
            'question' => 'Can tax refunds be partially approved?',
            'answer' => 'In some cases, yes. Refund approval may be adjusted based on verification results and program rules.

If partial approval occurs, your dashboard will show the approved amount clearly.

If you need clarification, support can provide the official decision summary available for your request.',
            'is_active' => true,
      ],
      [
            'category' => 'Tax Refund Services',
            'question' => 'Do tax refunds require compliance checks?',
            'answer' => 'Yes. Tax refund processing often includes compliance checks to prevent fraud and ensure accuracy.

These checks may include document verification, identity verification, and review of request consistency.

Compliance checks protect both customers and the financial system.',
            'is_active' => true,
      ],
      [
            'category' => 'Tax Refund Services',
            'question' => 'Where can I see my tax refund history?',
            'answer' => 'Your tax refund history is available in the Tax Refund section. It includes all submitted requests, status changes, and outcomes.

History records help with auditing, tracking, and support troubleshooting.

If you need official records, you can download statements where available.',
            'is_active' => true,
      ],

      // =========================================================
      // 9) FEES, LIMITS & COMPLIANCE (20)
      // =========================================================
      [
            'category' => 'Fees, Limits & Compliance',
            'question' => 'What fees does the platform charge?',
            'answer' => 'Fees depend on the services you use. Some accounts have no monthly fees, while certain services such as international transfers, card replacements, or expedited processing may include fees.

All fees are displayed before you confirm a transaction.

You can review fee details in your dashboard or in the terms for your account type.',
            'is_active' => true,
      ],
      [
            'category' => 'Fees, Limits & Compliance',
            'question' => 'Are there monthly maintenance fees?',
            'answer' => 'Monthly maintenance fees depend on your account type. Some accounts are free, while premium accounts may include a monthly service charge.

If a monthly fee applies, it will be shown in your account terms and dashboard.

We recommend reviewing your account plan details for a full breakdown.',
            'is_active' => true,
      ],
      [
            'category' => 'Fees, Limits & Compliance',
            'question' => 'What are daily transaction limits?',
            'answer' => 'Daily transaction limits restrict the maximum amount you can send, withdraw, or spend in a single day.

Limits are based on account type, verification level, and risk profile.

You can view your current limits in your dashboard and request increases where eligible.',
            'is_active' => true,
      ],
      [
            'category' => 'Fees, Limits & Compliance',
            'question' => 'Why do transaction limits exist?',
            'answer' => 'Limits exist to protect your account from fraud, reduce financial risk, and comply with regulatory standards.

They also help ensure stable processing and prevent abuse of financial services.

Higher limits may be available after verification upgrades or consistent account history.',
            'is_active' => true,
      ],
      [
            'category' => 'Fees, Limits & Compliance',
            'question' => 'How do I increase my limits?',
            'answer' => 'Limit increases may be available after completing additional identity verification or meeting certain account activity requirements.

You can request a limit review from your account settings where supported.

In some cases, support may request documents to justify higher limits.',
            'is_active' => true,
      ],
      [
            'category' => 'Fees, Limits & Compliance',
            'question' => 'Why is my account under compliance review?',
            'answer' => 'Compliance reviews occur to ensure transactions and account activity meet legal and regulatory standards.

This may be triggered by unusual transaction patterns, large transfers, verification issues, or external compliance requirements.

During review, some services may be restricted temporarily for safety.',
            'is_active' => true,
      ],
      [
            'category' => 'Fees, Limits & Compliance',
            'question' => 'How long does a compliance review take?',
            'answer' => 'Compliance review times vary depending on the issue. Some reviews are completed quickly, while others require manual investigation and document verification.

Your dashboard may show a status update or request additional information.

If you need urgent access, contact support for the latest review update.',
            'is_active' => true,
      ],
      [
            'category' => 'Fees, Limits & Compliance',
            'question' => 'Can compliance reviews restrict withdrawals?',
            'answer' => 'Yes. Withdrawals may be restricted during compliance review to protect funds and prevent unauthorized activity.

This is a standard banking practice and is designed to protect customers and the system.

Once the review is completed, normal access is restored where allowed.',
            'is_active' => true,
      ],
      [
            'category' => 'Fees, Limits & Compliance',
            'question' => 'Do you charge fees for failed transactions?',
            'answer' => 'In most cases, failed transactions do not incur fees. However, some external banks or payment providers may charge fees depending on the method used.

If a fee applies, it will be disclosed before you confirm the transaction.

If you believe you were charged incorrectly, contact support with transaction details.',
            'is_active' => true,
      ],
      [
            'category' => 'Fees, Limits & Compliance',
            'question' => 'What is a chargeback?',
            'answer' => 'A chargeback is a reversal initiated by a cardholder through their bank or card issuer, typically due to fraud or dispute.

Chargebacks may result in funds being removed from an account temporarily while the dispute is reviewed.

If you are affected by a chargeback, support can provide guidance on the dispute process.',
            'is_active' => true,
      ],
      [
            'category' => 'Fees, Limits & Compliance',
            'question' => 'What is anti-money laundering (AML) compliance?',
            'answer' => 'AML compliance refers to laws and policies designed to prevent illegal financial activity such as money laundering and fraud.

Banks and financial platforms are required to monitor transactions and verify customer identities.

These measures protect customers and ensure the platform operates legally and securely.',
            'is_active' => true,
      ],
      [
            'category' => 'Fees, Limits & Compliance',
            'question' => 'Why do you ask for proof of address?',
            'answer' => 'Proof of address is required in many regions to confirm identity and meet regulatory compliance standards.

It helps prevent identity fraud and ensures accurate account records.

Accepted documents usually include utility bills, bank statements, or official government correspondence.',
            'is_active' => true,
      ],
      [
            'category' => 'Fees, Limits & Compliance',
            'question' => 'Why do you ask for source of funds?',
            'answer' => 'Source of funds information may be required for compliance when large transactions occur or when regulations require additional verification.

This helps prevent financial crime and ensures transparency.

Providing accurate source of funds details helps reduce delays and account restrictions.',
            'is_active' => true,
      ],
      [
            'category' => 'Fees, Limits & Compliance',
            'question' => 'Do you report to government agencies?',
            'answer' => 'Financial platforms may be required by law to report certain transactions or suspicious activity to relevant authorities.

This is a standard compliance obligation and does not necessarily indicate wrongdoing.

We only report information as required by law and protect customer privacy within legal limits.',
            'is_active' => true,
      ],
      [
            'category' => 'Fees, Limits & Compliance',
            'question' => 'What happens if I provide false information?',
            'answer' => 'Providing false information may result in account restrictions, denial of services, or account closure depending on severity.

Accurate information is required for security and compliance.

If you made an honest mistake, contact support quickly so it can be corrected safely.',
            'is_active' => true,
      ],
      [
            'category' => 'Fees, Limits & Compliance',
            'question' => 'Can my account be closed for compliance reasons?',
            'answer' => 'Yes. Accounts may be closed if required by law, if serious compliance violations occur, or if verification cannot be completed.

This is done to protect the platform and customers.

If an account is closed, any remaining balances are handled according to legal and policy requirements.',
            'is_active' => true,
      ],
      [
            'category' => 'Fees, Limits & Compliance',
            'question' => 'What is a hold on funds?',
            'answer' => 'A hold on funds means a portion of your balance is temporarily unavailable. Holds may occur due to pending transactions, disputes, compliance reviews, or verification issues.

Holds are designed to protect both customers and the platform.

Once the reason for the hold is resolved, funds become available again.',
            'is_active' => true,
      ],
      [
            'category' => 'Fees, Limits & Compliance',
            'question' => 'How do I view my fees and charges?',
            'answer' => 'You can view fees and charges in your transaction history and account statements.

Some services also show a fee breakdown before you confirm a transaction.

If you need a detailed fee report, support can assist in generating transaction records where available.',
            'is_active' => true,
      ],
      [
            'category' => 'Fees, Limits & Compliance',
            'question' => 'Do you provide tax documents?',
            'answer' => 'Tax document availability depends on region and account type. Some accounts provide downloadable statements and annual summaries.

We provide transaction records and statements, but we do not provide tax advice.

For tax filing support, consult a licensed tax professional.',
            'is_active' => true,
      ],

      // =========================================================
      // 10) SUPPORT, DISPUTES & TROUBLESHOOTING (20)
      // =========================================================
      [
            'category' => 'Support, Disputes & Troubleshooting',
            'question' => 'How do I contact support?',
            'answer' => 'You can contact support through the Help section in your dashboard. Support may also be available via email depending on your region.

For faster assistance, include your account email and transaction reference number when applicable.

Support requests are handled securely and may require identity confirmation for sensitive actions.',
            'is_active' => true,
      ],
      [
            'category' => 'Support, Disputes & Troubleshooting',
            'question' => 'What information should I include when contacting support?',
            'answer' => 'When contacting support, include your registered email address, the issue summary, and any transaction references if relevant.

If the issue involves a transfer, include date, amount, and recipient details.

Clear information helps support resolve your issue faster and reduces the need for repeated follow-ups.',
            'is_active' => true,
      ],
      [
            'category' => 'Support, Disputes & Troubleshooting',
            'question' => 'How do I dispute a transaction?',
            'answer' => 'To dispute a transaction, contact support with the transaction reference and explain why you believe the transaction is incorrect or unauthorized.

You may be asked to provide supporting evidence such as receipts, screenshots, or merchant communication.

Dispute timelines vary depending on transaction type and banking network requirements.',
            'is_active' => true,
      ],
      [
            'category' => 'Support, Disputes & Troubleshooting',
            'question' => 'How long do disputes take?',
            'answer' => 'Dispute timelines depend on transaction type. Card disputes may take longer due to network rules, while internal disputes may be resolved faster.

We provide status updates as the dispute progresses.

If additional evidence is required, you will be notified to submit it within a specific timeframe.',
            'is_active' => true,
      ],
      [
            'category' => 'Support, Disputes & Troubleshooting',
            'question' => 'What happens if my dispute is approved?',
            'answer' => 'If your dispute is approved, the disputed amount may be refunded to your account depending on the case outcome.

Some disputes involve temporary credits while investigations are ongoing.

Final outcomes are communicated clearly, and transaction records will reflect the resolution.',
            'is_active' => true,
      ],
      [
            'category' => 'Support, Disputes & Troubleshooting',
            'question' => 'What happens if my dispute is rejected?',
            'answer' => 'If a dispute is rejected, it means the investigation did not support the claim under applicable rules.

We may provide a summary of the reason, such as merchant proof, authorization evidence, or compliance outcomes.

If you have new evidence, you may be able to submit it depending on dispute policy.',
            'is_active' => true,
      ],
      [
            'category' => 'Support, Disputes & Troubleshooting',
            'question' => 'Why does my balance look incorrect?',
            'answer' => 'Balance differences may occur due to pending transactions, card authorizations, holds, or delayed settlements.

Your dashboard separates total balance and available balance to help clarify what is spendable.

If your balance still looks incorrect after settlement, support can help review your transaction ledger.',
            'is_active' => true,
      ],
      [
            'category' => 'Support, Disputes & Troubleshooting',
            'question' => 'Why is my transaction missing from history?',
            'answer' => 'Missing transactions may occur if a transaction failed before being recorded, if a network delay occurred, or if filtering is applied.

Try refreshing your dashboard and checking different date ranges.

If the transaction is still missing, contact support with proof of the transaction attempt.',
            'is_active' => true,
      ],
      [
            'category' => 'Support, Disputes & Troubleshooting',
            'question' => 'Why am I seeing “something went wrong” errors?',
            'answer' => 'This error may occur due to temporary system issues, network problems, browser caching, or session timeouts.

Try refreshing the page, clearing cache, or logging out and back in.

If the issue continues, support can investigate system logs to identify the cause.',
            'is_active' => true,
      ],
      [
            'category' => 'Support, Disputes & Troubleshooting',
            'question' => 'How do I report a bug?',
            'answer' => 'To report a bug, contact support and include steps to reproduce the issue, screenshots if possible, and the device/browser you are using.

Bug reports help improve platform stability and user experience.

We prioritize bugs that affect security, payments, or account access.',
            'is_active' => true,
      ],
      [
            'category' => 'Support, Disputes & Troubleshooting',
            'question' => 'Can I request account statements from support?',
            'answer' => 'Yes. If statements are not available in your dashboard, support may be able to provide them depending on your region and policy.

Statements include transaction history, balances, and account identifiers for a given period.

For security, statement requests may require identity verification.',
            'is_active' => true,
      ],
      [
            'category' => 'Support, Disputes & Troubleshooting',
            'question' => 'How do I update my notification preferences?',
            'answer' => 'You can update notification preferences in your account settings. You can choose to receive alerts for transfers, withdrawals, card usage, and account security.

Notifications help you stay informed and detect unauthorized activity quickly.

We recommend keeping security alerts enabled at all times.',
            'is_active' => true,
      ],
      [
            'category' => 'Support, Disputes & Troubleshooting',
            'question' => 'Why am I not receiving transaction alerts?',
            'answer' => 'Transaction alerts may fail due to disabled notification settings, email delivery issues, or phone number verification problems.

Check your notification preferences and ensure your email/phone is correct.

If alerts remain unavailable, support can help verify delivery settings.',
            'is_active' => true,
      ],
      [
            'category' => 'Support, Disputes & Troubleshooting',
            'question' => 'How do I export my transactions?',
            'answer' => 'If export is available, you can download transactions from your transaction history as a CSV or PDF.

Exports are useful for budgeting, tax preparation, and recordkeeping.

If exports are not available, support may be able to provide transaction records upon request.',
            'is_active' => true,
      ],
      [
            'category' => 'Support, Disputes & Troubleshooting',
            'question' => 'Can I request a transaction trace?',
            'answer' => 'Yes. For external bank transfers, support can provide a trace reference depending on the banking network.

Traces help confirm whether a transfer reached the recipient bank.

To request a trace, provide the transaction ID, amount, date, and recipient details.',
            'is_active' => true,
      ],
      [
            'category' => 'Support, Disputes & Troubleshooting',
            'question' => 'How do I change my account currency?',
            'answer' => 'Currency changes may be available depending on your account type and region. Some accounts have a fixed currency, while others support multi-currency features.

If currency change is supported, you can request it in account settings.

Currency changes may affect limits, fees, and available services.',
            'is_active' => true,
      ],
      [
            'category' => 'Support, Disputes & Troubleshooting',
            'question' => 'Why was my account restricted?',
            'answer' => 'Accounts may be restricted due to compliance review, verification issues, suspicious activity, disputes, or policy enforcement.

Restrictions are designed to protect your funds and platform integrity.

Your dashboard may show the reason, and support can provide next steps to restore access.',
            'is_active' => true,
      ],
      [
            'category' => 'Support, Disputes & Troubleshooting',
            'question' => 'How do I remove a restriction from my account?',
            'answer' => 'To remove restrictions, follow the steps shown in your dashboard. This may include completing verification, providing documents, or resolving disputes.

Support can assist in clarifying what is required and reviewing submissions.

Once requirements are satisfied, restrictions are typically lifted automatically.',
            'is_active' => true,
      ],
      [
            'category' => 'Support, Disputes & Troubleshooting',
            'question' => 'Where can I see platform announcements?',
            'answer' => 'Platform announcements are shown in your dashboard notifications and may also be sent via email depending on your preferences.

Announcements include maintenance updates, feature releases, and important security alerts.

We recommend reviewing announcements regularly to stay informed about service changes.',
            'is_active' => true,
      ],

];
