<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Bank Account Types
    |--------------------------------------------------------------------------
    |
    | Define all the available bank account types for the onboarding process.
    | Each account type has a key, a label, an optional emoji, and a numeric
    | code to use in auto-generating account numbers.
    |
    */

    'account_types' => [
        'savings' => [
            'label' => 'Savings Account',
            'emoji' => '💰',
            'code' => 101,
        ],
        'checking' => [
            'label' => 'Checking Account',
            'emoji' => '🏦',
            'code' => 102,
        ],
        'business' => [
            'label' => 'Business Account',
            'emoji' => '💼',
            'code' => 103,
        ],
        'joint' => [
            'label' => 'Joint Account',
            'emoji' => '👥',
            'code' => 104,
        ],
        'student' => [
            'label' => 'Student Account',
            'emoji' => '🎓',
            'code' => 105,
        ],
        'salary' => [
            'label' => 'Salary Account',
            'emoji' => '💵',
            'code' => 106,
        ],
        'fixed_deposit' => [
            'label' => 'Fixed Deposit Account',
            'emoji' => '📈',
            'code' => 107,
        ],
        'current' => [
            'label' => 'Current Account',
            'emoji' => '🏛️',
            'code' => 108,
        ],
        'investment' => [
            'label' => 'Investment Account',
            'emoji' => '📊',
            'code' => 109,
        ],
        'non_resident' => [
            'label' => 'Non-Resident (NRI) Account',
            'emoji' => '🌍',
            'code' => 110,
        ],
    ],

];

