<?php

namespace App\View\Components\Account;

use App\Models\Account;
use App\Support\Currency;
use Closure;
use Illuminate\Contracts\View\View;
use Illuminate\View\Component;

class Limits extends Component
{
    /**
     * Create a new component instance.
     */
    public Account $account;
    public string $currencySymbol;

    /**
     * Create a new component instance.
     *
     * @param Account $account
     */
    public function __construct(Account $account)
    {
        $this->account = $account;

        // Fetch currency from account → profile
        $this->currencySymbol = $account->profile
            ? Currency::symbol($account->profile->currency)
            : '$';
    }


    /**
     * Get the view / contents that represent the component.
     */
    public function render(): View|Closure|string
    {
        return view('components.account.limits');
    }
}
