<?php

namespace App\Traits;

trait WithTableHelpers
{
    public string $search = '';
    public string $sortField = 'created_at';
    public string $sortDirection = 'desc';

    protected $queryString = [
        'search' => ['except' => ''],
        'sortField' => ['except' => 'created_at'],
        'sortDirection' => ['except' => 'desc'],
        'statusFilter' => ['except' => ''],
        'page' => ['except' => 1],
    ];

    public function updatingSearch()
    {
        $this->resetPage();
    }
    public function updatingStatusFilter()
    {
        $this->resetPage();
    }

    public function sortBy($field)
    {
        $this->resetPage();
        if ($this->sortField === $field) {
            $this->sortDirection = $this->sortDirection === 'asc' ? 'desc' : 'asc';
        } else {
            $this->sortField = $field;
            $this->sortDirection = 'asc';
        }

        $this->resetPage();
    }

    protected function applySearch($query, array $fields): void
    {
        $term = trim(strtolower($this->search));

        if (!$term)
            return;

        $likeTerm = '%' . $term . '%';
        $baseTable = $query->getModel()->getTable();

        $query->where(function ($q) use ($fields, $likeTerm, $baseTable) {
            foreach ($fields as $field) {
                if (str_contains($field, '.')) {
                    $parts = explode('.', $field);
                    $column = array_pop($parts);         // last part is the column
                    $relation = implode('.', $parts);    // remaining is the relation path

                    $q->orWhereHas($relation, function ($sub) use ($column, $likeTerm) {
                        $sub->where($column, 'like', $likeTerm);
                    });
                } else {
                    $q->orWhere("{$baseTable}.{$field}", 'like', $likeTerm);
                }
            }
        });
    }


}
