<?php

namespace App\Notifications;

use App\Models\Transaction;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class TransactionNotification extends Notification
{
    protected Transaction $transaction;

    public function __construct(Transaction $transaction)
    {
        $this->transaction = $transaction;
    }

    public function via($notifiable)
    {
        return ['mail', 'database'];
    }

    public function toMail($notifiable): MailMessage
    {
        $url = url('/user/transactions');
        $transactionMessage = $this->transaction->generateMessage();

        $subject = ucfirst($this->transaction->typeLabel()) . ' Notification';
        return (new MailMessage)
            ->subject($subject)
            ->view('emails.transaction-notification', [
                'transaction' => $this->transaction,
                'transactionMessage' => $transactionMessage,
                'url' => $url,
                'subject' => $subject,
            ]);
    }


    public function toDatabase($notifiable): array
    {
        return [
            'transaction_id' => $this->transaction->id,
            'title' => $this->transaction->title(),
            'message' => $this->transaction->generateMessage(),
            'link' => url('/transactions'),
        ];
    }
}
