<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Notification;
use Illuminate\Notifications\Messages\MailMessage;
use App\Models\Ticket;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\BroadcastMessage;

class TicketCreated extends Notification
{

    protected $ticket;

    public function __construct(Ticket $ticket)
    {
        $this->ticket = $ticket;
    }

    /**
     * Notification channels
     */
    public function via($notifiable)
    {
        return ['mail', 'database']; // mail and database
    }

    /**
     * Mail representation using your email layout
     */
    public function toMail(object $notifiable): MailMessage
    {
        return (new MailMessage)
            ->subject('Your Support Ticket Has Been Created')
            ->view('emails.ticket-created', [ // custom blade view
                'user' => $notifiable,
                'ticket' => $this->ticket,
            ]);
    }

    /**
     * Database representation
     */
    public function toArray($notifiable)
    {
        return [
            'title' => 'Support Ticket Created', // Notification title
            'message' => 'Your ticket "' . $this->ticket->subject . '" has been successfully created.', // Optional extra message
            'ticket_id' => $this->ticket->id,
            'subject' => $this->ticket->subject,
            'priority' => $this->ticket->priority,
            'status' => $this->ticket->status,
            'link' => route('user.ticket.show', $this->ticket->id), // URL to view ticket
        ];
    }

}
