<?php
namespace App\Notifications;

use Illuminate\Notifications\Notification;
use Illuminate\Notifications\Messages\MailMessage;
use App\Models\Loan;
use App\Models\LoanInstallment;

class LoanReminderNotification extends Notification
{

    protected Loan $loan;
    protected LoanInstallment $installment;

    public function __construct(Loan $loan, LoanInstallment $installment)
    {
        $this->loan = $loan;
        $this->installment = $installment;
    }

    public function via($notifiable)
    {
        return ['mail', 'database'];
    }

    public function toMail($notifiable)
    {
        return (new MailMessage)
            ->subject('Upcoming Loan Payment Reminder')
            ->greeting("Hello {$notifiable->name},")
            ->line("This is a reminder that your loan installment #{$this->installment->installment_number} is due soon.")
            ->line("Due Date: {$this->installment->due_date->format('F d, Y')}")
            ->line("Amount Due: {$this->installment->total}")
            ->line("Remaining Loan Balance: {$this->loan->remaining_balance}")
            ->action('View Loan Details', url('/loans/' . $this->loan->id))
            ->line('Please ensure sufficient funds are available if auto-debit is enabled.');
    }

    public function toArray($notifiable)
    {
        return [
            'loan_id' => $this->loan->id,
            'installment_number' => $this->installment->installment_number,
            'amount_due' => $this->installment->total,
            'due_date' => $this->installment->due_date,
            'status' => 'upcoming',

            // New fields for frontend display
            'title' => 'Upcoming Loan Installment',
            'message' => "Your loan installment #{$this->installment->installment_number} is due on {$this->installment->due_date->format('F d, Y')} for amount {$this->installment->total}.",
        ];
    }

}
