<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Notification;
use Illuminate\Notifications\Messages\MailMessage;
use App\Models\Contact;

class ContactCreated extends Notification
{
    use Queueable;

    protected $contact;

    public function __construct(Contact $contact)
    {
        $this->contact = $contact;
    }

    public function via($notifiable)
    {
        return ['mail', 'database'];
    }

    public function toMail($notifiable)
    {
        return (new MailMessage)
            ->subject('We Received Your Message')
            ->view('emails.contact-created', [
                'contact' => $this->contact,
            ]);
    }

    public function toArray($notifiable)
    {
        return [
            'title' => 'New Contact Message',
            'message' => 'Message from "' . $this->contact->fullname . '" regarding "' . $this->contact->subject . '"',
            'contact_id' => $this->contact->id,
            'email' => $this->contact->email,
            'link' => route('admin.dashboard', $this->contact->id), // admin view link
        ];
    }
}
