<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PaymentMethod extends Model
{
    use HasFactory;

    protected $fillable = [
        'type',
        'name',
        'logo',
        'instructions',
        'details',
        'fields',
        'fee_percent',
        'is_active',
    ];

    protected $casts = [
        'instructions' => 'array',
        'details' => 'array',
        'fields' => 'array',
        'fee_percent' => 'float',
        'is_active' => 'boolean',
    ];

    public function getLogoUrlAttribute()
    {
        return $this->logo ? asset('storage/' . $this->logo) : null;
    }


    public function cryptoWallets()
    {
        return $this->hasMany(CryptoWallet::class);
    }

    public function deposits()
    {
        return $this->hasMany(Deposit::class);
    }

    public function withdrawals()
    {
        return $this->hasMany(Withdrawal::class);
    }
    public function transfers()
    {
        return $this->hasMany(Transfer::class);
    }
}
