<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class OnboardingAudit extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'current_step',
        'data',
        'country',
        'state',
        'status',
    ];

    protected $casts = [
        'data' => 'array',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
