<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class GrantLog extends Model
{
    use HasFactory;

    protected $fillable = [
        'grant_id',
        'user_id',
        'action',
        'data',
    ];

    protected $casts = [
        'data' => 'array',
    ];

    public function grant()
    {
        return $this->belongsTo(Grant::class);
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
