<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class PreventSuspendedUsers
{
    public function handle(Request $request, Closure $next)
    {
        if (Auth::check() && Auth::user()->profile?->status === 'suspended') {

            Auth::logout();

            $request->session()->invalidate();
            $request->session()->regenerateToken();

            return redirect()->route('account.suspended');
        }

        return $next($request);
    }
}


