<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Log;
use Symfony\Component\HttpFoundation\Response;

class EnsureCompleteProfile
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        $user = Auth::user();

        $isComplete = $user->isProfileComplete();

        if (!$isComplete) {
            return redirect()->route('onboarding')->with([
                'message' => 'Please complete your profile first.',
                'type' => 'error',
            ]);
        }

        return $next($request);
    }

}
