<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Password;

class ForgotPasswordController extends Controller
{
    public function store(Request $request)
    {
        $request->validate([
            'email' => 'required|email',
        ]);

        $status = Password::sendResetLink($request->only('email'));

        if ($status === Password::RESET_LINK_SENT) {
            return back()->with([
                'message' => __($status),
                'type' => 'success', // green toast
            ]);
        } else {
            return back()->with([
                'message' => __($status),
                'type' => 'error', // red toast
            ]);
        }
    }
}
