<?php

use Illuminate\Support\Facades\Route;

if (!function_exists('currentPageInfo')) {

      /**
       * Get the current page info (title, welcome message, etc.)
       */
      function currentPageInfo($authUser)
      {
            // Define all pages
            $pages = [
                  'user.dashboard' => [
                        'title' => 'Dashboard',
                        'showWelcome' => true,
                        'welcome' => 'Welcome back, ' . $authUser->name,
                  ],
                  'user.transactions' => [
                        'title' => 'Transactions',
                  ],
                  'user.virtual.cards' => [
                        'title' => 'Virtual Cards',
                        'showWelcome' => true,
                        'welcome' => 'Secure virtual cards for online payments and subscriptions',
                  ],
                  'user.deposit' => [
                        'title' => 'Deposit',
                        'showWelcome' => true,
                        'welcome' => 'Add money to your account securely',
                  ],
                  'user.withdrawal' => [
                        'title' => 'Withdrawal',
                        'showWelcome' => true,
                        'welcome' => 'Transfer funds securely from your account',
                  ],
                  'user.local.transfer' => [
                        'title' => 'Local Transfer',
                        'showWelcome' => true,
                        'welcome' => 'Send money to any local bank account securely and instantly',
                  ],
                  'user.international.transfer' => [
                        'title' => 'International Transfer',
                        'showWelcome' => true,
                        'welcome' => 'Send money worldwide with multiple payment methods',
                  ],
                  'user.balance.swap' => [
                        'title' => 'Currency Swap',
                        'showWelcome' => true,
                        'welcome' => 'Easily convert between accounts and Bitcoin',
                  ],
                  // Section-level defaults (no need for "*")
                  'user.loans' => [
                        'title' => 'Loan Services',
                        'showWelcome' => true,
                        'welcome' => 'Manage your loans easily and securely.',
                  ],
                  'user.tax' => [
                        'title' => 'Tax Services',
                        'showWelcome' => true,
                        'welcome' => 'Manage your tax easily and securely.',
                  ],
                  'user.grants' => [
                        'title' => 'Grant Services',
                        'showWelcome' => true,
                        'welcome' => 'Apply & manage grants.',
                  ],
                  'user.settings' => [
                        'title' => 'Account Settings',
                        'showWelcome' => true,
                        'welcome' => 'Manage your profile and security settings.',
                  ],
                  'user.ticket' => [
                        'title' => 'Support Center',
                        'showWelcome' => true,
                        'welcome' => 'Get help with your account and services.',
                  ],
            ];

            $routeName = Route::currentRouteName();

            // Try exact match first
            if (isset($pages[$routeName])) {
                  $page = $pages[$routeName];
            } else {
                  // Check for section-level matches by prefix
                  $page = [];
                  foreach ($pages as $key => $value) {
                        if (str_starts_with($routeName, $key . '.')) {
                              $page = $value;
                              break;
                        }
                  }
            }

            // Return page info with defaults
            return [
                  'title' => $page['title'] ?? 'Page',
                  'showWelcome' => $page['showWelcome'] ?? false,
                  'welcome' => $page['welcome'] ?? 'Welcome back, ' . $authUser->name,
            ];
      }
}
