<?php

namespace App\Exports;

use Illuminate\Support\Collection;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;

class GenericExport implements FromCollection, WithHeadings
{
      protected Collection $data;
      protected array $headings;

      public function __construct(Collection $data, array $headings)
      {
            $this->data = $data;
            $this->headings = $headings;
      }

      public function collection(): Collection
      {
            return $this->data->map(fn($row) => array_values($row));
      }

      public function headings(): array
      {
            return $this->headings;
      }
}
